/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task;

import com.huawei.osc.acl.AclConstants;
import com.huawei.osc.acl.task.GetAclValueTask;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import uds.common.config.interf.OBSConfig;
import uds.common.config.util.OBSThreadPoolFactory;

public class GetAclValueTaskListener {
    private static final long DEFAULT_THIRD_ACL_POLICY_PERIOD = OBSConfig.getInstance().getLong(AclConstants.ObsTaskConfig.THIRD_ACL_POLICY_PERIOD.getConfigKey(), AclConstants.ObsTaskConfig.THIRD_ACL_POLICY_PERIOD.getDefaultValueLong());
    private static final GetAclValueTask GET_ACL_VALUE_TASK = new GetAclValueTask();
    private volatile ScheduledExecutorService executor;

    private GetAclValueTaskListener() {
    }

    public static GetAclValueTaskListener getInstance() {
        return SingletonHolder.instance;
    }

    public synchronized void initialize() {
        if (this.executor == null) {
            this.executor = OBSThreadPoolFactory.createThreadPool((int)1, (String)"get_third_acl_policies_task");
            this.executor.scheduleWithFixedDelay(GET_ACL_VALUE_TASK, 0L, DEFAULT_THIRD_ACL_POLICY_PERIOD, TimeUnit.MILLISECONDS);
        }
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public void setExecutor(ScheduledExecutorService executor) {
        this.executor = executor;
    }

    public boolean isExecutorOk() {
        return this.executor != null;
    }

    public boolean isAllAclPoliciesCleared() {
        return GET_ACL_VALUE_TASK.getLastAclMap().isEmpty();
    }

    private static class SingletonHolder {
        private static GetAclValueTaskListener instance = new GetAclValueTaskListener();

        private SingletonHolder() {
        }
    }
}

