/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task;

import com.huawei.osc.acl.dao.ThirdAclPolicyDao;
import com.huawei.osc.acl.dao.ThirdAclPolicyDaoSpi;
import com.huawei.osc.acl.task.MemcacheAction;
import com.huawei.osc.acl.task.MemcacheActionType;
import com.huawei.osc.acl.task.PolicyLocalCacheProcessor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.OBSConfig;
import uds.common.config.util.OBSThreadPoolFactory;
import uds.common.storage.exception.StorEngineException;

public class MemcacheActionProcessor
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(MemcacheActionProcessor.class);
    private static final long TASK_PERIOD = 500L;
    private static final MemcacheActionProcessor INSTANCE = new MemcacheActionProcessor();
    private final Map<Integer, MemcacheAction> actionMap = new HashMap<Integer, MemcacheAction>();
    private volatile ScheduledExecutorService executor;
    private final ThirdAclPolicyDao dao = ThirdAclPolicyDaoSpi.getInstance();
    private final PolicyLocalCacheProcessor localCache = PolicyLocalCacheProcessor.getInstance();

    private MemcacheActionProcessor() {
    }

    public static MemcacheActionProcessor getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
        if (this.executor == null) {
            this.executor = OBSThreadPoolFactory.createThreadPool((int)1, (String)"ccdb-action-processor");
            this.executor.scheduleWithFixedDelay(INSTANCE, 0L, 500L, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
        this.actionMap.clear();
    }

    public synchronized void put(int namespaceId, MemcacheAction memcacheAction) {
        this.actionMap.put(namespaceId, memcacheAction);
    }

    @Override
    public void run() {
        try {
            this.process();
        }
        catch (Throwable e) {
            log.error("process memcache action failed", e);
        }
    }

    private synchronized void process() {
        if (this.actionMap.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Integer, MemcacheAction>> it = this.actionMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Integer, MemcacheAction> entry = it.next();
            boolean isProcessSuccess = this.processAction(entry.getKey(), entry.getValue());
            if (!isProcessSuccess) continue;
            it.remove();
        }
    }

    private boolean processAction(int namespaceId, MemcacheAction action) {
        if (action == null) {
            return true;
        }
        boolean isSuccess = false;
        if (action.getType() == MemcacheActionType.DELETE) {
            try {
                if (OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile()) {
                    this.localCache.deleteAclPolicyByNamespaceId(namespaceId);
                } else {
                    this.dao.deleteAclPolicyByNamespaceId(namespaceId);
                }
                log.warn("deleteAclPolicyByNamespaceId [{}] success", (Object)namespaceId);
                isSuccess = true;
            }
            catch (StorEngineException e) {
                log.error("deleteAclPolicyByNamespaceId [" + namespaceId + "] failed", (Throwable)e);
            }
        } else {
            try {
                if (OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile()) {
                    this.localCache.writeAclPolicy(action.getPolicy());
                } else {
                    this.dao.writeAclPolicy(action.getPolicy());
                }
                log.warn("writeAclPolicy [{}] success", (Object)action.getPolicy().getVersion());
                isSuccess = true;
            }
            catch (StorEngineException e) {
                log.error("writeAclPolicy [" + action.getPolicy() + "] failed", (Throwable)e);
            }
        }
        return isSuccess;
    }
}

