/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task;

import com.huawei.osc.acl.dao.ThirdAclPolicyInfo;
import com.huawei.osc.acl.task.SubNotifyTask;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.eds.client.ThirdAclPolicy;

public class PolicyLocalCacheProcessor {
    private static final Logger log = LoggerFactory.getLogger(PolicyLocalCacheProcessor.class);
    private static final PolicyLocalCacheProcessor INSTANCE = new PolicyLocalCacheProcessor();
    private ConcurrentHashMap<Integer, ThirdAclPolicy> localAclPolicyCache = new ConcurrentHashMap();
    private boolean isGetPolicy = false;

    public static PolicyLocalCacheProcessor getInstance() {
        return INSTANCE;
    }

    public boolean isGetPolicy() {
        return this.isGetPolicy;
    }

    public void writeAclPolicy(ThirdAclPolicy policy) {
        if (policy == null) {
            throw new IllegalArgumentException("policy can not be null.");
        }
        int namespaceId = policy.getNamespaceId();
        ThirdAclPolicy localPolicy = this.getAclPolicyByNamespaceId(namespaceId);
        if (localPolicy == null || localPolicy != null && policy.getVersion() != localPolicy.getVersion()) {
            this.localAclPolicyCache.put(namespaceId, policy);
            if (!this.isGetPolicy) {
                this.isGetPolicy = true;
            }
            SubNotifyTask.getInstance().setUpdateFlag();
            log.warn("writeAclPolicy in localCache, version is {}, namespaceid is {}", (Object)policy.getVersion(), (Object)policy.getNamespaceId());
        }
    }

    public ThirdAclPolicy getAclPolicyByNamespaceId(int namespaceId) {
        if (namespaceId <= 0) {
            throw new IllegalArgumentException("invalid namspace id.");
        }
        ThirdAclPolicy thirdAclPolicy = this.localAclPolicyCache.getOrDefault(namespaceId, null);
        return thirdAclPolicy;
    }

    public List<ThirdAclPolicyInfo> getAllPolicyVersionInfo() {
        LinkedList<ThirdAclPolicyInfo> result = new LinkedList<ThirdAclPolicyInfo>();
        for (Map.Entry<Integer, ThirdAclPolicy> entry : this.localAclPolicyCache.entrySet()) {
            int namespaceId = entry.getKey();
            ThirdAclPolicy thirdAclPolicy = entry.getValue();
            ThirdAclPolicyInfo policyInfo = ThirdAclPolicyInfo.builder().namespaceId(namespaceId).type(thirdAclPolicy.getType()).version(thirdAclPolicy.getVersion()).build();
            result.add(policyInfo);
        }
        return result;
    }

    public void deleteAclPolicyByNamespaceId(int namespaceId) {
        ThirdAclPolicy localPolicy = this.getAclPolicyByNamespaceId(namespaceId);
        if (localPolicy != null) {
            this.localAclPolicyCache.remove(namespaceId);
            SubNotifyTask.getInstance().setUpdateFlag();
            log.warn("delete cache,namespaceId is: {}", (Object)namespaceId);
        }
    }
}

