/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task;

import com.huawei.osc.acl.dao.ThirdAclPolicyDao;
import com.huawei.osc.acl.dao.ThirdAclPolicyDaoSpi;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.OBSConfig;
import uds.common.config.util.OBSThreadPoolFactory;
import uds.common.storage.exception.StorEngineException;

public class SubNotifyTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(SubNotifyTask.class);
    private static final long TASK_PERIOD = 5000L;
    private static final SubNotifyTask INSTANCE = new SubNotifyTask();
    private volatile ScheduledExecutorService executor;
    private final ThirdAclPolicyDao dao = ThirdAclPolicyDaoSpi.getInstance();
    private volatile boolean hasUpdateFlag = false;

    private SubNotifyTask() {
    }

    public static SubNotifyTask getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
        if (this.executor == null) {
            this.executor = OBSThreadPoolFactory.createThreadPool((int)1, (String)"sub-notify-processor");
            this.executor.scheduleWithFixedDelay(INSTANCE, 0L, 5000L, TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    @Override
    public void run() {
        log.info("==> SubNotifyTask run...");
        try {
            int result = 0;
            if (!OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile()) {
                result = this.dao.subAclPolicyNotify(ignored -> {
                    log.info("== get callback from ccdb");
                    this.hasUpdateFlag = true;
                });
            }
            log.error("<== SubNotifyTask return, result = {}", (Object)result);
        }
        catch (StorEngineException e) {
            log.error("<== subAclPolicyNotify StorEngine failed", (Throwable)e);
        }
        catch (Throwable t) {
            log.error("<== subAclPolicyNotify unknown error", t);
        }
    }

    public boolean getUpdateFlag() {
        return this.hasUpdateFlag;
    }

    public void clearUpdateFlag() {
        this.hasUpdateFlag = false;
    }

    public void setUpdateFlag() {
        this.hasUpdateFlag = true;
    }
}

