/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task;

import com.huawei.osc.acl.AclInfoAdapter;
import com.huawei.osc.acl.common.ThirdAclUtils;
import com.huawei.osc.acl.task.MemcacheAction;
import com.huawei.osc.acl.task.MemcacheActionProcessor;
import com.huawei.osc.acl.task.MemcacheActionType;
import com.huawei.osc.acl.task.ThirdAclConfigMonitor;
import java.io.File;
import org.apache.commons.io.monitor.FileAlterationListenerAdaptor;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThirdAclConfigListener
extends FileAlterationListenerAdaptor {
    private static final Logger LOG = LogManager.getLogger(ThirdAclConfigListener.class);
    private final ThirdAclConfigMonitor monitor;

    public ThirdAclConfigListener(ThirdAclConfigMonitor monitor) {
        this.monitor = monitor;
    }

    public void onFileChange(File file) {
        String filename = file.getName();
        LOG.warn("==>ThirdAclConfigListener.onFileChange: {}", (Object)filename);
        try {
            this.checkConfigAndStartPlugin(filename);
        }
        catch (Throwable t) {
            LOG.error("onFileChange failed", t);
        }
        LOG.warn("<==ThirdAclConfigListener.onFileChange: {}", (Object)filename);
    }

    public void onFileCreate(File file) {
        String filename = file.getName();
        LOG.warn("==>ThirdAclConfigListener.{}: {}", (Object)"onFileCreate", (Object)filename);
        try {
            this.checkConfigAndStartPlugin(filename);
        }
        catch (Throwable t) {
            LOG.error("onFileCreate failed", t);
        }
        LOG.warn("<==ThirdAclConfigListener.{}: {}", (Object)"onFileCreate", (Object)filename);
    }

    public void onFileDelete(File file) {
        String filename = file.getName();
        LOG.warn("==>ThirdAclConfigListener.onFileDelete: {}", (Object)filename);
        try {
            String[] parts = filename.split("-");
            int namespaceId = NumberUtils.toInt((String)parts[2], (int)-1);
            if (namespaceId <= 0) {
                LOG.error("invalid file format:{}", (Object)file.getName());
            } else if (this.monitor.contains(namespaceId)) {
                this.monitor.get(namespaceId).stop();
                this.monitor.remove(namespaceId);
                MemcacheActionProcessor.getInstance().put(namespaceId, MemcacheAction.builder().type(MemcacheActionType.DELETE).build());
            }
        }
        catch (Throwable t) {
            LOG.error("onFileDelete failed", t);
        }
        LOG.warn("<==ThirdAclConfigListener.onFileDelete: {}", (Object)filename);
    }

    private void checkConfigAndStartPlugin(String filename) {
        AclInfoAdapter aclAdapter = ThirdAclUtils.buildAclInfoAdapterByConfig(filename);
        if (aclAdapter == null) {
            LOG.error("buildAclInfoAdapterByConfig failed, skip... filename={}", (Object)filename);
            return;
        }
        if (this.monitor.get(aclAdapter.getNamespaceId()) != null) {
            this.monitor.get(aclAdapter.getNamespaceId()).stop();
        }
        this.monitor.put(aclAdapter.getNamespaceId(), aclAdapter);
        aclAdapter.start();
    }
}

