/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task;

import com.huawei.osc.acl.AclInfoAdapter;
import com.huawei.osc.acl.common.ThirdAclUtils;
import com.huawei.osc.acl.dao.ThirdAclPolicyDao;
import com.huawei.osc.acl.dao.ThirdAclPolicyDaoSpi;
import com.huawei.osc.acl.dao.ThirdAclPolicyInfo;
import com.huawei.osc.acl.task.MemcacheAction;
import com.huawei.osc.acl.task.MemcacheActionProcessor;
import com.huawei.osc.acl.task.MemcacheActionType;
import com.huawei.osc.acl.task.PolicyLocalCacheProcessor;
import com.huawei.osc.acl.task.ThirdAclConfigListener;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.io.filefilter.AbstractFileFilter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uds.common.config.interf.OBSConfig;
import uds.common.storage.exception.StorEngineException;

public class ThirdAclConfigMonitor {
    private static final Logger LOG = LogManager.getLogger(ThirdAclConfigMonitor.class);
    private static final ThirdAclConfigMonitor INSTANCE = new ThirdAclConfigMonitor();
    private static final long WATCH_INTERVAL = 5L;
    private final Map<Integer, AclInfoAdapter> namespaceIdPluginMap = new HashMap<Integer, AclInfoAdapter>();
    private FileAlterationMonitor configMonitor;
    private boolean isRunning = false;
    private final ThirdAclPolicyDao dao = ThirdAclPolicyDaoSpi.getInstance();
    private final PolicyLocalCacheProcessor localCache = PolicyLocalCacheProcessor.getInstance();

    private ThirdAclConfigMonitor() {
    }

    public static ThirdAclConfigMonitor getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
        LOG.warn("==>ThirdAclConfigMonitor.start()");
        this.doStart();
        LOG.warn("<==ThirdAclConfigMonitor.start()");
    }

    private void doStart() {
        try {
            this.startPlugins();
            FileAlterationObserver observer = new FileAlterationObserver("/opt/dfv/obs_service_layer/objectwebservice/osc/conf/third_acl", (FileFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.fileFileFilter(), new AbstractFileFilter(){

                public boolean accept(File file) {
                    return ThirdAclConfigMonitor.accept(file);
                }
            }}), null);
            observer.addListener((FileAlterationListener)new ThirdAclConfigListener(this));
            this.configMonitor = new FileAlterationMonitor(TimeUnit.SECONDS.toMillis(5L), new FileAlterationObserver[]{observer});
            this.configMonitor.start();
            this.isRunning = true;
        }
        catch (Throwable e) {
            LOG.error("ThirdAclConfigMonitor start failed", e);
        }
    }

    public static boolean accept(String fileName) {
        return ThirdAclConfigMonitor.accept(new File(fileName));
    }

    public static boolean accept(File file) {
        try {
            if (!file.getName().startsWith("ranger-hdfs") && !file.getName().startsWith("sentry-hdfs")) {
                return false;
            }
            PosixFileAttributes attrs = Files.readAttributes(file.toPath(), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
            GroupPrincipal group = attrs.group();
            Set<PosixFilePermission> permissions = attrs.permissions();
            return StringUtils.equals((String)group.getName(), (String)"storage") && permissions != null && permissions.contains((Object)PosixFilePermission.GROUP_READ);
        }
        catch (Throwable e) {
            LOG.error("check file acceptable failed", e);
            return false;
        }
    }

    private void startPlugins() throws StorEngineException {
        File configDir = new File("/opt/dfv/obs_service_layer/objectwebservice/osc/conf/third_acl");
        if (!configDir.isDirectory()) {
            return;
        }
        Map<Integer, AclInfoAdapter> pluginMap = this.buildPluginMap(configDir);
        this.cleanVersion(pluginMap.keySet());
        for (AclInfoAdapter aclInfoAdapter : pluginMap.values()) {
            LOG.warn("==>start plugin, namespace={}", (Object)aclInfoAdapter.getNamespaceId());
            try {
                aclInfoAdapter.start();
                this.namespaceIdPluginMap.put(aclInfoAdapter.getNamespaceId(), aclInfoAdapter);
            }
            catch (Throwable e) {
                LOG.error("start aclInfoAdapter failed.", e);
            }
            LOG.warn("<==start plugin, namespace={}", (Object)aclInfoAdapter.getNamespaceId());
        }
    }

    private void cleanVersion(Set<Integer> configNsIds) throws StorEngineException {
        List<ThirdAclPolicyInfo> policiesInDB = OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile() ? this.localCache.getAllPolicyVersionInfo() : this.dao.getAllPolicyVersionInfo();
        LOG.warn("== policy in db = {}, ns with conf file = {}", policiesInDB, configNsIds);
        if (!CollectionUtils.isEmpty(policiesInDB)) {
            Set<Integer> toDelete = policiesInDB.stream().map(ThirdAclPolicyInfo::getNamespaceId).collect(Collectors.toSet());
            toDelete.removeAll(configNsIds);
            LOG.warn("== namespace to delete: {}", toDelete);
            toDelete.forEach(policyId -> MemcacheActionProcessor.getInstance().put((int)policyId, MemcacheAction.builder().type(MemcacheActionType.DELETE).build()));
        }
    }

    private Map<Integer, AclInfoAdapter> buildPluginMap(File configDir) {
        HashMap<Integer, AclInfoAdapter> map = new HashMap<Integer, AclInfoAdapter>();
        for (String configFileName : configDir.list()) {
            if (!ThirdAclConfigMonitor.accept("/opt/dfv/obs_service_layer/objectwebservice/osc/conf/third_acl/" + configFileName)) {
                LOG.error("file {} invalid, skip...", (Object)configFileName);
                continue;
            }
            AclInfoAdapter aclAdapter = ThirdAclUtils.buildAclInfoAdapterByConfig(configFileName);
            if (aclAdapter == null) {
                LOG.error("build buildAclInfoAdapterByConfig failed, skip... config={}", (Object)configFileName);
                continue;
            }
            map.put(aclAdapter.getNamespaceId(), aclAdapter);
        }
        return map;
    }

    public synchronized void stop() {
        LOG.warn("==>RangerPolicyConfigMonitor.stop()");
        try {
            this.configMonitor.stop();
        }
        catch (Exception e) {
            LOG.error("stop file monitor failed", (Throwable)e);
        }
        for (AclInfoAdapter aclInfoAdapter : this.namespaceIdPluginMap.values()) {
            aclInfoAdapter.stop();
        }
        this.namespaceIdPluginMap.clear();
        this.isRunning = false;
        LOG.warn("<==RangerPolicyConfigMonitor.stop()");
    }

    public synchronized boolean isRunning() {
        return this.isRunning;
    }

    public synchronized AclInfoAdapter get(int namespaceId) {
        return this.namespaceIdPluginMap.get(namespaceId);
    }

    public synchronized boolean contains(int namespaceId) {
        return this.namespaceIdPluginMap.containsKey(namespaceId);
    }

    public synchronized void put(int namespaceId, AclInfoAdapter aclInfoAdapter) {
        this.namespaceIdPluginMap.put(namespaceId, aclInfoAdapter);
    }

    public synchronized void remove(int namespaceId) {
        this.namespaceIdPluginMap.remove(namespaceId);
    }
}

