/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task;

import com.huawei.osc.acl.alarm.ThirdAclServerStatusMonitor;
import com.huawei.osc.acl.task.MemcacheActionProcessor;
import com.huawei.osc.acl.task.ThirdAclConfigMonitor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uds.common.config.interf.OBSConfig;
import uds.common.config.util.OBSThreadPoolFactory;
import uds.common.masterelect.MasterSelectAdapter;

public class ThirdAclManagerTask
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ThirdAclManagerTask.class);
    private static final ThirdAclManagerTask INSTANCE = new ThirdAclManagerTask();
    private static final long TASK_PERIOD = 5L;
    private volatile ScheduledExecutorService executor;
    private boolean isOldSwitchOn = false;

    private ThirdAclManagerTask() {
    }

    public static ThirdAclManagerTask getInstance() {
        return INSTANCE;
    }

    public synchronized void start() {
        if (this.executor == null) {
            this.executor = OBSThreadPoolFactory.createThreadPool((int)1, (String)"ranger-manager-task");
            this.executor.scheduleWithFixedDelay(INSTANCE, 0L, 5L, TimeUnit.SECONDS);
        }
    }

    public synchronized void stop() {
        if (this.executor != null) {
            this.executor.shutdown();
            this.executor = null;
        }
    }

    @Override
    public void run() {
        try {
            if (OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile() != this.isOldSwitchOn) {
                LOG.warn("switch has changed, stop ranger plugin");
                if (ThirdAclConfigMonitor.getInstance().isRunning()) {
                    MemcacheActionProcessor.getInstance().stop();
                    ThirdAclServerStatusMonitor.getInstance().stop();
                    ThirdAclConfigMonitor.getInstance().stop();
                }
                this.isOldSwitchOn = OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile();
            }
            if (OBSConfig.getInstance().getIsRangerPolicySaveToLocalFile()) {
                if (!ThirdAclConfigMonitor.getInstance().isRunning()) {
                    LOG.warn("ranger only save to local, start ranger plugin");
                    ThirdAclConfigMonitor.getInstance().start();
                    ThirdAclServerStatusMonitor.getInstance().start();
                    MemcacheActionProcessor.getInstance().start();
                    this.isOldSwitchOn = true;
                }
                return;
            }
            this.isOldSwitchOn = false;
            if (!ThirdAclConfigMonitor.getInstance().isRunning() && MasterSelectAdapter.getInstance().isMaster()) {
                LOG.warn("I am master, start ranger plugin");
                ThirdAclConfigMonitor.getInstance().start();
                ThirdAclServerStatusMonitor.getInstance().start();
                MemcacheActionProcessor.getInstance().start();
                return;
            }
            if (ThirdAclConfigMonitor.getInstance().isRunning() && !MasterSelectAdapter.getInstance().isMaster()) {
                LOG.warn("I am not master, stop ranger plugin");
                MemcacheActionProcessor.getInstance().stop();
                ThirdAclServerStatusMonitor.getInstance().stop();
                ThirdAclConfigMonitor.getInstance().stop();
            }
        }
        catch (Throwable t) {
            LOG.error("failed when ThirdAclManagerTask.run()", t);
        }
    }
}

