/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.osc.acl.task.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorShutdownSupport {
    private static final Logger log = LoggerFactory.getLogger(ExecutorShutdownSupport.class);
    private static final long DEFAULT_AWAIT_TERMINATION = 20L;
    private long awaitTermination;
    private TimeUnit timeUnit;

    public ExecutorShutdownSupport() {
        this(20L, TimeUnit.SECONDS);
    }

    public ExecutorShutdownSupport(long awaitTermination, TimeUnit timeUnit) {
        this.awaitTermination = awaitTermination;
        this.timeUnit = timeUnit;
        if (this.awaitTermination <= 0L) {
            this.awaitTermination = 20L;
        }
        if (this.timeUnit == null) {
            this.timeUnit = TimeUnit.SECONDS;
        }
    }

    public boolean shutdown(ExecutorService executor, boolean isWaitForTasksToCompleteOnShutdown) {
        if (executor == null) {
            return true;
        }
        if (!executor.isShutdown()) {
            if (isWaitForTasksToCompleteOnShutdown) {
                executor.shutdown();
            } else {
                executor.shutdownNow();
            }
        }
        return this.awaitTerminationIfNecessary(executor);
    }

    private boolean awaitTerminationIfNecessary(ExecutorService executor) {
        boolean isShutDownSuccess = true;
        try {
            isShutDownSuccess = executor.awaitTermination(this.awaitTermination, this.timeUnit);
        }
        catch (InterruptedException e) {
            log.error("this shutdown request meet Exception.", (Throwable)e);
            return false;
        }
        if (!isShutDownSuccess) {
            log.info("this shutdown request occurs timeout.");
            return false;
        }
        return true;
    }
}

