#!/bin/bash

file_path=/opt/dsware/infrastructure/ccdb/ccdb_server/script/dr_ccdb_util.sh
# shellcheck disable=SC2002
comment=$(cat "${file_path}" |grep -E "/sys/fs/cgroup/cpu/tasks" | xargs echo)
if [[  x"${comment}" == x"echo \$\$ > /sys/fs/cgroup/cpu/tasks" ]]; then
	echo "not need to sed for cgroup"
	exit 0
fi

sed -i 's#/sys/fs/cgroup/cpu/tasks.*#/sys/fs/cgroup/cpu/tasks#1'  ${file_path}; echo $?
# shellcheck disable=SC2002
comment=$(cat "${file_path}" |grep -E "/sys/fs/cgroup/cpu/tasks" | xargs echo)
if [[  x"${comment}" != x"echo \$\$ > /sys/fs/cgroup/cpu/tasks" ]]; then
	echo "sed for cgroup error"
	exit 1
fi

sh /opt/dsware/infrastructure/ccdb/ccdb_server/script/ccdb_server_process_handle.sh stop
if [ $? -ne 0 ]; then
	echo "ccdb stop error, please check"
	exit 2
fi

sh /opt/dsware/infrastructure/ccdb/ccdb_server/script/ccdb_server_process_handle.sh start

if [ $? -ne 0 ]; then
	echo "start error, please check"
	exit 3
fi
exit 0
