# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import utils.common.log as logger
from utils.common.fic_base import TestCase
from utils.client.FSPAuthClient import FSPAuthClient
from utils.Driver.CloudDC.OpenStack.get_host_info import GetHostInfo
from plugins.DistributedStorage.scripts.logic.InstallOperate import InstallOperate
from plugins.DistributedStorage.scripts.utils.config.device_check import DeviceResource


class InstallRole(TestCase):
    def __init__(self, project_id, pod_id, fs_args, **kwargs):
        super(InstallRole, self).__init__(project_id, pod_id)
        self.fs_args = fs_args
        self.operate = InstallOperate(self.project_id, self.pod_id, self.fs_args)
        self.cps_web_client = FSPAuthClient.get_cps_web_client(self.db, self.project_id, self.pod_id)
        self.cps_host_client = GetHostInfo(self.cps_web_client)
        self.check = DeviceResource()
        self.nodes = self.db.get_bmc_info_by_pod_id(pod_id=self.pod_id)
        self.more_args = kwargs

    def procedure(self):
        # 1. 配置计算存储融合节点fusionstorage-blockXXX角色
        osd_bmc_ip_list = [osd.get('bmc_ip') for osd in self.fs_args.get('osd_list')]
        compute_storage_id_list = list()
        if osd_bmc_ip_list:
            compute_storage_id_list, compute_storage_ip_list = self.cps_host_client.get_host_info(osd_bmc_ip_list)
            osd_memory = self.fs_args.get('osd_memory')
            osd_cpu = self.fs_args.get('osd_cpu')
            logger.info('Start config and install role for node%s' % compute_storage_ip_list)
            self.operate.config_and_deploy_role(compute_storage_id_list, osd_cpu, osd_memory)

        # 2. 配置计算节点fusionstorage-blockXXX角色
        all_vbs_bmc_ip_list = [vbs.get('bmc_ip') for vbs in self.fs_args.get('vbs_list')]
        vbs_bmc_ip_list = set(all_vbs_bmc_ip_list).difference(set(osd_bmc_ip_list))
        compute_id_list, compute_ip_list = self.cps_host_client.get_host_info(vbs_bmc_ip_list)
        if len(compute_id_list) > 0:
            vbs_cpu = 4
            vbs_memory = 7
            logger.info('Start config and install role for node%s' % compute_ip_list)
            self.operate.config_and_deploy_role(compute_id_list, vbs_cpu, vbs_memory)

        if not compute_storage_id_list and not compute_id_list:
            err_msg = "The node list is empty. There is no node to install role"
            logger.error(err_msg)
            raise Exception(err_msg)

        logger.info('Checking FusionStorage-Agent rpm package')
        self.operate.check_vbs_node_fusionstorage_agent_rpm(self.fs_args.get('fsa_list'))

    def cleanup(self):
        vbs_bmc_ip_list = [vbs.get('bmc_ip') for vbs in self.fs_args.get('vbs_list')]
        vbs_host_id_list, vbs_host_ip_list = self.cps_host_client.get_host_info(vbs_bmc_ip_list)
        cps_client = FSPAuthClient.get_cps_rest_client(self.db, self.project_id, self.pod_id)
        logger.info("Stop fusionstorage-blockXXX role nodes%s" % str(vbs_host_ip_list))
        self.operate.stop_fusionstorage_block_template(cps_client, vbs_host_id_list)
        logger.info("Cleaning up fusionstorage-blockXXX role nodes%s" % str(vbs_host_ip_list))
        self.operate.remove_fusionstorage_block_role(cps_client, vbs_host_id_list)
        logger.info("Checking fusionstorage-blockXXX role nodes%s" % str(vbs_host_ip_list))
        self.operate.check_fusionstorage_block_on_host(cps_client, vbs_host_id_list)
