# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
from utils.common.fic_base import StepBaseInterface
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.message import Message
from utils.common.exception import FCDException
from plugins.DistributedStorageReplication.scripts.implement.tc_add_node import AddNode
from plugins.DistributedStorageReplication.scripts.common_utils.config_params import Params


class AddNodeIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.service_name = "FusionStorageBlockReplication"
        parameters = Params(self.project_id, self.pod_id, self.service_name)
        self.fs_args = parameters.get_rep_fsa_params()
        self.add_node = AddNode(self.project_id, self.pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.add_node.procedure()
        except FCDException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626065, str(e)))
        return Message()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.add_node.cleanup()
        except FCDException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626065, str(e)))
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        try:
            self.add_node.reset_all_nodes()
        except FCDException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626065, str(e)))
        try:
            self.add_node.procedure()
        except FCDException as e:
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626065, str(e)))
        return Message()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
