# !/bin/sh

source ../../common/InfoStreamDs_1.0_Patch_Common
patch_name=InfoStreamDs_1.0_Patch_Fix_Log_Collect
shell_name=$0

function stop_legacy_logback_process()
{
    local pids
    pids=($(ps -ef | grep ivsbackupd | grep -v grep | awk '{print $2}'))
    pids+=($(ps -ef |grep java | grep -v grep | grep ivs_backuplog | awk '{print $2}'))

    if [ "${#pids[*]}" -ne 0 ]; then
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "legacy logbak system(pids ${pids[*]}) is running, ready to stop"
        for pid in "${pids[@]}"; do
            kill -9 "$pid"
        done
    fi
}

function install_log_bak
{
	if [ -f  /home/ivstool/bin/log_bak.sh ]; then
		Log "$shell_name" "$FUNCNAME" "$LINENO" "/home/ivstool/bin/log_bak.sh exist"
		return
	fi
	
	# 没有9000_挂载点，不备份
	mnt_path=`mount | grep nfs | grep mnt |  awk -F' ' '{ print $3  }'`
	if [ "$mnt_path" == "" ]; then
		Log "$shell_name" "$FUNCNAME" "$LINENO" "mount path error"
		return
	fi
	
	cp log_bak.sh /home/ivstool/bin/
	cd /home/ivstool/bin/
	sh log_bak.sh &
	cd -
}

function fix_collect_mod
{
	cp collect.sh /home/ivstool/collect/
	chmod 755 -R /home/ivstool/collect
}


function show_usage
{
    echo "usage: sh $0"
}

# 输入参数检查，参数个数0
function check_param
{
    if [ $# -ne 0 ];then
	    show_usage
		return 1
	fi
}

check_param $@
if [ $? -ne 0 ]; then
    Log "$shell_name" "$FUNCNAME" "$LINENO" "check param err"
	report_error $patch_name
    exit 1
fi

install_log_bak
fix_collect_mod

sleep 1

if crontab -l | grep -q "log_bak.sh"; then
	stop_legacy_logback_process
	Log "$shell_name" "$FUNCNAME" "$LINENO" "install $patch_name success."
	report_success $patch_name
	exit 0
else
	Log "$shell_name" "$FUNCNAME" "$LINENO" "install $patch_name failed, log_bak task not exist in crontab."
	report_error $patch_name
	exit 1
fi
