#!/bin/sh

# 修复删除国标设备时，互联编码删除不彻底的问题
source ../../common/InfoStreamDs_1.0_Patch_Common
patch_name=InfoStreamDs_1.0_Patch_Fix_Manual_Shift_Start_Time
shell_name=$0

function load_sql_function
{
	cp ivs_center_trigger.sql /home/ivspkgback/script/
	chmod 755 /home/ivspkgback/script/
	chmod 755 /home/ivspkgback/script/ivs_center_trigger.sql
	su - center -c "psql -f /home/ivspkgback/script/ivs_center_trigger.sql" >/dev/null 2>&1 
 
	Log "$shell_name" "$FUNCNAME" "$LINENO" "install $patch_name success."
	report_success $patch_name
}

function show_usage
{
    echo "usage: sh $0"
}

# 输入参数检查，参数个数0
function check_param
{
    if [ $# -ne 0 ];then
	    show_usage
		return 1
	fi
}

check_param $@
if [ $? -ne 0 ]; then
    Log "$shell_name" "$FUNCNAME" "$LINENO" "check param err"
	report_error $patch_name
    exit 1
fi

load_sql_function
