#!/bin/sh
# 修复ivsoper密码过期的补丁

source ../../common/InfoStreamDs_1.0_Patch_Common

function fix_ivsoperPwdExpired()
{
    chage -M 99999 ivsoper
    if [ $? -ne 0 ]; then
        Log "$FUNCNAME" "$LINENO" "chage for ivsoper fail"
        return 1
    fi
    
    cp ./fix_ivsoper_pwd.sh /home/ivstool/bin/fix_ivsoper_pwd.sh
    if [ $? -ne 0 ]; then
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "cp fix_ivsoper_pwd.sh error"
        return 1
    fi
    
    chmod 500 /home/ivstool/bin/fix_ivsoper_pwd.sh
    
    # 加入定时任务，防止物理机重启后设置失效
    crontab -l | grep -q "fix_ivsoper_pwd.sh"
    if [ $? -ne 0 ];then
        crontab -l > ./crontab.log
        echo '0 0 * * * /home/ivstool/bin/fix_ivsoper_pwd.sh' >> ./crontab.log
        crontab < ./crontab.log
        rm -f ./crontab.log
    fi
}

fix_ivsoperPwdExpired
