#!/bin/sh

# 停止imug，并重命名
source ../../common/InfoStreamDs_1.0_Patch_Common
patch_name=InfoStreamDs_1.0_Patch_Modify_Nfs_Param
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"

function modify_nfs_param
{
    sed -i 's/vm.dirty_background_ratio=.*/vm.dirty_background_ratio=40/'  /etc/sysctl.d/20-euler.conf
    sed -i 's/vm.dirty_ratio=.*/vm.dirty_ratio=45/' /etc/sysctl.d/20-euler.conf
    
    sysctl --system >/dev/null 2>&1
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install $patch_name success."
    report_success $patch_name
}

function show_usage
{
    echo "usage: sh $0"
}

# 输入参数检查，参数个数0
function check_param
{
    if [ $# -ne 0 ];then
        show_usage
        return 1
    fi
}

check_param $@
if [ $? -ne 0 ]; then
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "check param err"
    report_error $patch_name
    exit 1
fi

modify_nfs_param
