create or replace function proc_smu_cluster_role() returns integer as 
$body$
declare
    cluster_role integer;
    record_count integer;
begin
    cluster_role := -1;
    select count(*) into record_count from tbl_smu_node_info as tbl_node, tbl_smu_domain_info as tbl_domain where tbl_node.node_code=tbl_domain.node_code;
    if record_count = 1 then
       select role into cluster_role from tbl_smu_node_info as tbl_node, tbl_smu_domain_info as tbl_domain where tbl_node.node_code=tbl_domain.node_code;
    end if;
    return cluster_role;
end;
$body$ language plpgsql;
alter function proc_smu_cluster_role() owner to smuadmin;

------1 tbl_smu_alarm_subscribe
create or replace function proc_write_unsync_alarm_subscribe() returns trigger as $proc_write_unsync_alarm_subscribe$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_alarm_subscribe';
    fieldone := 'id'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_alarm_subscribe$ language plpgsql;
alter function proc_write_unsync_alarm_subscribe() owner to smuadmin;
    
drop trigger if exists tri_unsync_alarm_subscribe on tbl_smu_alarm_subscribe;
create trigger tri_unsync_alarm_subscribe after insert or update or delete on tbl_smu_alarm_subscribe
    for each row execute procedure proc_write_unsync_alarm_subscribe();

------2 tbl_smu_subscribe_alarm_level
create or replace function proc_write_unsync_subscribe_alarm_level() returns trigger as $proc_write_unsync_subscribe_alarm_level$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_subscribe_alarm_level';
    fieldone := 'alarm_subscribe_id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.alarm_subscribe_id as varchar(32));
        else
            valueone := cast(new.alarm_subscribe_id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_subscribe_alarm_level$ language plpgsql;
alter function proc_write_unsync_subscribe_alarm_level() owner to smuadmin;
    
drop trigger if exists tri_unsync_subscribe_alarm_level on tbl_smu_subscribe_alarm_level;
create trigger tri_unsync_subscribe_alarm_level after insert or update or delete on tbl_smu_subscribe_alarm_level
    for each row execute procedure proc_write_unsync_subscribe_alarm_level();

------3 tbl_smu_alarm_linkage
create or replace function proc_write_unsync_alarm_linkage() returns trigger as $proc_write_unsync_alarm_linkage$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_alarm_linkage';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_alarm_linkage$ language plpgsql;
alter function proc_write_unsync_alarm_linkage() owner to smuadmin;
    
drop trigger if exists tri_unsync_alarm_linkage on tbl_smu_alarm_linkage;
create trigger tri_unsync_alarm_linkage after insert or update or delete on tbl_smu_alarm_linkage
    for each row execute procedure proc_write_unsync_alarm_linkage();    
        
------4 tbl_smu_alarm_linkage_action
create or replace function proc_write_unsync_alarm_linkage_action() returns trigger as $proc_write_unsync_alarm_linkage_action$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_alarm_linkage_action';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_alarm_linkage_action$ language plpgsql;
alter function proc_write_unsync_alarm_linkage_action() owner to smuadmin;
    
drop trigger if exists tri_unsync_alarm_linkage_action on tbl_smu_alarm_linkage_action;
create trigger tri_unsync_alarm_linkage_action after insert or update or delete on tbl_smu_alarm_linkage_action
    for each row execute procedure proc_write_unsync_alarm_linkage_action();    

------5 tbl_smu_alarm_area
create or replace function proc_write_unsync_alarm_area() returns trigger as $proc_write_unsync_alarm_area$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_alarm_area';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_alarm_area$ language plpgsql;
alter function proc_write_unsync_alarm_area() owner to smuadmin;
    
drop trigger if exists tri_unsync_alarm_area on tbl_smu_alarm_area;
create trigger tri_unsync_alarm_area after insert or update or delete on tbl_smu_alarm_area
    for each row execute procedure proc_write_unsync_alarm_area();    

------6 tbl_smu_domain_info
create or replace function proc_write_unsync_smu_domain_info() returns trigger as $proc_write_unsync_smu_domain_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_domain_info';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_smu_domain_info$ language plpgsql;
alter function proc_write_unsync_smu_domain_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_smu_domain_info on tbl_smu_domain_info;
create trigger tri_unsync_smu_domain_info after insert or update or delete on tbl_smu_domain_info
    for each row execute procedure proc_write_unsync_smu_domain_info();    
    
------7 tbl_smu_node_info
create or replace function proc_write_unsync_node_info() returns trigger as $proc_write_unsync_node_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_node_info';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_node_info$ language plpgsql;
alter function proc_write_unsync_node_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_node_info on tbl_smu_node_info;
create trigger tri_unsync_node_info after insert or update or delete on tbl_smu_node_info
    for each row execute procedure proc_write_unsync_node_info();    

------8 tbl_smu_group_info
create or replace function proc_write_unsync_group_info() returns trigger as $proc_write_unsync_group_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_group_info';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_group_info$ language plpgsql;
alter function proc_write_unsync_group_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_group_info on tbl_smu_group_info;
create trigger tri_unsync_group_info after insert or update or delete on tbl_smu_group_info
    for each row execute procedure proc_write_unsync_group_info();

------9 tbl_smu_user_info
create or replace function proc_write_unsync_user_info() returns trigger as $proc_write_unsync_user_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_user_info';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_user_info$ language plpgsql;
alter function proc_write_unsync_user_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_user_info on tbl_smu_user_info;
create trigger tri_unsync_user_info after insert or update or delete on tbl_smu_user_info
    for each row execute procedure proc_write_unsync_user_info();    

------10 tbl_smu_role_info
create or replace function proc_write_unsync_role_info() returns trigger as $proc_write_unsync_role_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_role_info';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_role_info$ language plpgsql;
alter function proc_write_unsync_role_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_role_info on tbl_smu_role_info;
create trigger tri_unsync_role_info after insert or update or delete on tbl_smu_role_info
    for each row execute procedure proc_write_unsync_role_info();        

------11 tbl_smu_sys_operation_info
create or replace function proc_write_unsync_sys_operation_info() returns trigger as $proc_write_unsync_sys_operation_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_sys_operation_info';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_sys_operation_info$ language plpgsql;
alter function proc_write_unsync_sys_operation_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_sys_operation_info on tbl_smu_sys_operation_info;
create trigger tri_unsync_sys_operation_info after insert or update or delete on tbl_smu_sys_operation_info
    for each row execute procedure proc_write_unsync_sys_operation_info();    

------12 tbl_smu_acc_rule_info
create or replace function proc_write_unsync_acc_rule_info() returns trigger as $proc_write_unsync_acc_rule_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_acc_rule_info';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_acc_rule_info$ language plpgsql;
alter function proc_write_unsync_acc_rule_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_acc_rule_info on tbl_smu_acc_rule_info;
create trigger tri_unsync_acc_rule_info after insert or update or delete on tbl_smu_acc_rule_info
    for each row execute procedure proc_write_unsync_acc_rule_info();

------13 tbl_smu_user_device_info
create or replace function proc_write_unsync_user_device_info() returns trigger as $proc_write_unsync_user_device_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_user_device_info';
    fieldone := 'id'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_user_device_info$ language plpgsql;
alter function proc_write_unsync_user_device_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_user_device_info on tbl_smu_user_device_info;
create trigger tri_unsync_user_device_info after insert or update or delete on tbl_smu_user_device_info
    for each row execute procedure proc_write_unsync_user_device_info();

------14 tbl_smu_online_user
create or replace function proc_write_unsync_online_user() returns trigger as $proc_write_unsync_online_user$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_online_user';
    fieldone := 'id'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_online_user$ language plpgsql;
alter function proc_write_unsync_online_user() owner to smuadmin;
    
drop trigger if exists tri_unsync_online_user on tbl_smu_online_user;
create trigger tri_unsync_online_user after insert or update or delete on tbl_smu_online_user
    for each row execute procedure proc_write_unsync_online_user();
    
------15 tbl_smu_dev_route
--create or replace function proc_write_unsync_dev_route() returns trigger as $proc_write_unsync_dev_route$
--declare
--    iscluster integer;
--    tablename varchar(32);    
--    fieldone varchar(32);
--    valueone varchar(32);     
--    fieldtwo varchar(32);
--    valuetwo varchar(32);
--    fieldthree varchar(32);
--    valuethree varchar(32);    
--begin
--    tablename := 'tbl_smu_dev_route';
--    fieldone := 'id'; 
--    select proc_smu_cluster_role() into iscluster;
--    if iscluster = 1 then
--        if (tg_op = 'DELETE') then
--            valueone := cast(old.id as varchar(32));
--        else
--            valueone := cast(new.id as varchar(32));
--        end if;
--        if (valueone is not null) then
--            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
--            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
--        end if;
--    end if;
--    return null;
--end;
--$proc_write_unsync_dev_route$ language plpgsql;
--alter function proc_write_unsync_dev_route() owner to smuadmin;
--    
--drop trigger if exists tri_unsync_dev_route on tbl_smu_dev_route;
--create trigger tri_unsync_dev_route after insert or update or delete on tbl_smu_dev_route
--    for each row execute procedure proc_write_unsync_dev_route();

------16 tbl_smu_dictionary_info
create or replace function proc_write_unsync_dictionary_info() returns trigger as $proc_write_unsync_dictionary_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_dictionary_info';
    fieldone := 'id'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_dictionary_info$ language plpgsql;
alter function proc_write_unsync_dictionary_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_dictionary_info on tbl_smu_dictionary_info;
create trigger tri_unsync_dictionary_info after insert or update or delete on tbl_smu_dictionary_info
    for each row execute procedure proc_write_unsync_dictionary_info();

------17 tbl_smu_plan
create or replace function proc_write_unsync_plan() returns trigger as $proc_write_unsync_plan$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_plan';
    fieldone := 'id'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_plan$ language plpgsql;
alter function proc_write_unsync_plan() owner to smuadmin;
    
drop trigger if exists tri_unsync_plan on tbl_smu_plan;
create trigger tri_unsync_plan after insert or update or delete on tbl_smu_plan
    for each row execute procedure proc_write_unsync_plan();

------18 tbl_smu_snapshot
create or replace function proc_write_unsync_snapshot() returns trigger as $proc_write_unsync_snapshot$
declare
    iscluster integer;
    iChanNum integer;
    tablename varchar(32);
    fieldone varchar(32);
    valueone varchar(32); 
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_snapshot';
    fieldone := 'id'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
            select count(chanel_code) into iChanNum from tbl_smu_dev_chanel_relation where chanel_code = old.camera_code;
            if (iChanNum = 0) then
               return null;
            end if;
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_snapshot$ language plpgsql;
alter function proc_write_unsync_snapshot() owner to smuadmin;
    
drop trigger if exists tri_unsync_snapshot on tbl_smu_snapshot;
    
------20 tbl_smu_transparent
create or replace function proc_write_unsync_transparent() returns trigger as $proc_write_unsync_transparent$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_transparent';
    fieldone := 'id'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_transparent$ language plpgsql;
alter function proc_write_unsync_transparent() owner to smuadmin;
    
drop trigger if exists tri_unsync_transparent on tbl_smu_transparent;
create trigger tri_unsync_transparent after insert or update or delete on tbl_smu_transparent
    for each row execute procedure proc_write_unsync_transparent();
    
------21 tbl_smu_mtu_info
create or replace function proc_write_unsync_mtu_info() returns trigger as $proc_write_unsync_mtu_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_mtu_info';
    fieldone := 'id'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_mtu_info$ language plpgsql;
alter function proc_write_unsync_mtu_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_mtu_info on tbl_smu_mtu_info;
create trigger tri_unsync_mtu_info after insert or update or delete on tbl_smu_mtu_info
    for each row execute procedure proc_write_unsync_mtu_info();
    
------22 tbl_smu_cluster_info
create or replace function proc_write_unsync_cluster_info() returns trigger as $proc_write_unsync_cluster_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_cluster_info';
    fieldone := 'cluster_code'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.cluster_code as varchar(32));
        else
            valueone := cast(new.cluster_code as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_cluster_info$ language plpgsql;
alter function proc_write_unsync_cluster_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_cluster_info on tbl_smu_cluster_info;
create trigger tri_unsync_cluster_info after insert or update or delete on tbl_smu_cluster_info
    for each row execute procedure proc_write_unsync_cluster_info();




---------TWO PK TABLES    
------23 tbl_smu_alarm_help_info
create or replace function proc_write_unsync_alarm_help_info() returns trigger as $proc_write_unsync_alarm_help_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_alarm_help_info';
    fieldone := 'source_id';
    fieldtwo := 'source_type';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.source_id as varchar(32));
            valuetwo := cast(old.source_type as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.source_id as varchar(32));
                valuetwo := cast(old.source_type as varchar(32));
                if (valueone is not null or valuetwo is not null) then
                    delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                    insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.source_id as varchar(32));
            valuetwo := cast(new.source_type as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone  and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);
            
        end if;
    end if;
    return null;
end;
$proc_write_unsync_alarm_help_info$ language plpgsql;
alter function proc_write_unsync_alarm_help_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_alarm_help_info on tbl_smu_alarm_help_info;
create trigger tri_unsync_alarm_help_info after insert or update or delete on tbl_smu_alarm_help_info
    for each row execute procedure proc_write_unsync_alarm_help_info();

------24 tbl_smu_subscribe_alarm_type
create or replace function proc_write_unsync_subscribe_alarm_type() returns trigger as $proc_write_unsync_subscribe_alarm_type$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_subscribe_alarm_type';    
    fieldone := 'alarm_subscribe_id';
    fieldtwo := 'alarm_type_id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.alarm_subscribe_id as varchar(32));
            valuetwo := cast(old.alarm_type_id as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.alarm_subscribe_id as varchar(32));
                valuetwo := cast(old.alarm_type_id as varchar(32));
                if (valueone is not null or valuetwo is not null ) then
                    delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                    insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.alarm_subscribe_id as varchar(32));
            valuetwo := cast(new.alarm_type_id as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone  and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_subscribe_alarm_type$ language plpgsql;
alter function proc_write_unsync_subscribe_alarm_type() owner to smuadmin;
    
drop trigger if exists tri_unsync_subscribe_alarm_type on tbl_smu_subscribe_alarm_type;
create trigger tri_unsync_subscribe_alarm_type after insert or update or delete on tbl_smu_subscribe_alarm_type
    for each row execute procedure proc_write_unsync_subscribe_alarm_type();

------25 tbl_smu_alarm_area_dev
create or replace function proc_write_unsync_smu_alarm_area_dev() returns trigger as $proc_write_unsync_smu_alarm_area_dev$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_alarm_area_dev';
    fieldone := 'alarm_area_id';
    fieldtwo := 'alarm_in_code';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.alarm_area_id as varchar(32));
            valuetwo := cast(old.alarm_in_code as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.alarm_area_id as varchar(32));
                valuetwo := cast(old.alarm_in_code as varchar(32));
                if (valueone is not null or valuetwo is not null) then
                    delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                    insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.alarm_area_id as varchar(32));
            valuetwo := cast(new.alarm_in_code as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_smu_alarm_area_dev$ language plpgsql;
alter function proc_write_unsync_smu_alarm_area_dev() owner to smuadmin;
    
drop trigger if exists tri_unsync_smu_alarm_area_dev on tbl_smu_alarm_area_dev;
create trigger tri_unsync_smu_alarm_area_dev after insert or update or delete on tbl_smu_alarm_area_dev
    for each row execute procedure proc_write_unsync_smu_alarm_area_dev();        

    
------26 tbl_smu_group_user_info
create or replace function proc_write_unsync_group_user_info() returns trigger as $proc_write_unsync_group_user_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_group_user_info';
    fieldone := 'group_id';
    fieldtwo := 'user_id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.group_id as varchar(32));
            valuetwo := cast(old.user_id as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.group_id as varchar(32));
                valuetwo := cast(old.user_id as varchar(32));
                if (valueone is not null or valuetwo is not null) then
                    delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                    insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.group_id as varchar(32));
            valuetwo := cast(new.user_id as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_group_user_info$ language plpgsql;
alter function proc_write_unsync_group_user_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_group_user_info on tbl_smu_group_user_info;
create trigger tri_unsync_group_user_info after insert or update or delete on tbl_smu_group_user_info
    for each row execute procedure proc_write_unsync_group_user_info();
    
    
------27 tbl_smu_user_role_info
create or replace function proc_write_unsync_user_role_info() returns trigger as $proc_write_unsync_user_role_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_user_role_info';
    fieldone := 'user_id';
    fieldtwo := 'role_id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.user_id as varchar(32));
            valuetwo := cast(old.role_id as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.user_id as varchar(32));
                valuetwo := cast(old.role_id as varchar(32));
                if (valueone is not null or valuetwo is not null) then
                    delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                    insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.user_id as varchar(32));
            valuetwo := cast(new.role_id as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_user_role_info$ language plpgsql;
alter function proc_write_unsync_user_role_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_user_role_info on tbl_smu_user_role_info;
create trigger tri_unsync_user_role_info after insert or update or delete on tbl_smu_user_role_info
    for each row execute procedure proc_write_unsync_user_role_info();
    

------28 tbl_smu_role_operation_info
create or replace function proc_write_unsync_role_operation_info() returns trigger as $proc_write_unsync_role_operation_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_role_operation_info';
    fieldone := 'role_id';
    fieldtwo := 'operation_id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.role_id as varchar(32));
            valuetwo := cast(old.operation_id as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.role_id as varchar(32));
                valuetwo := cast(old.operation_id as varchar(32));
                if (valueone is not null or valuetwo is not null) then
                delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.role_id as varchar(32));
            valuetwo := cast(new.operation_id as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_role_operation_info$ language plpgsql;
alter function proc_write_unsync_role_operation_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_role_operation_info on tbl_smu_role_operation_info;
create trigger tri_unsync_role_operation_info after insert or update or delete on tbl_smu_role_operation_info
    for each row execute procedure proc_write_unsync_role_operation_info();
    
    
------29 tbl_smu_role_accrule_info
create or replace function proc_write_unsync_role_accrule_info() returns trigger as $proc_write_unsync_role_accrule_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_role_accrule_info';
    fieldone := 'role_id';
    fieldtwo := 'accrule_id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.role_id as varchar(32));
            valuetwo := cast(old.accrule_id as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.role_id as varchar(32));
                valuetwo := cast(old.accrule_id as varchar(32));
                if (valueone is not null or valuetwo is not null) then
                delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.role_id as varchar(32));
            valuetwo := cast(new.accrule_id as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_role_accrule_info$ language plpgsql;
alter function proc_write_unsync_role_accrule_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_role_accrule_info on tbl_smu_role_accrule_info;
create trigger tri_unsync_role_accrule_info after insert or update or delete on tbl_smu_role_accrule_info
    for each row execute procedure proc_write_unsync_role_accrule_info();
    
------30 tbl_smu_dev_grp_info
create or replace function proc_write_unsync_dev_grp_info() returns trigger as $proc_write_unsync_dev_grp_info$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_dev_grp_info';
    fieldone := 'id'; 
    fieldtwo= 'domain_code';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
            valuetwo := cast(old.domain_code as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.id as varchar(32));
                valuetwo := cast(old.domain_code as varchar(32));
                if (valueone is not null or valuetwo is not null) then
                delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.id as varchar(32));
            valuetwo := cast(new.domain_code as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_dev_grp_info$ language plpgsql;
alter function proc_write_unsync_dev_grp_info() owner to smuadmin;
    
drop trigger if exists tri_unsync_dev_grp_info on tbl_smu_dev_grp_info;
create trigger tri_unsync_dev_grp_info after insert or update or delete on tbl_smu_dev_grp_info
    for each row execute procedure proc_write_unsync_dev_grp_info();
    
------31 tbl_smu_camera_info
--create or replace function proc_write_unsync_camera_info() returns trigger as $proc_write_unsync_camera_info$
--declare
--    iscluster integer;
--    tablename varchar(32);    
--    fieldone varchar(32);
--    valueone varchar(32);     
--    fieldtwo varchar(32);
--    valuetwo varchar(32);
--    fieldthree varchar(32);
--    valuethree varchar(32);    
--begin
--    tablename := 'tbl_smu_camera_info';
--    fieldone := 'camera_code';
--    fieldtwo := 'domain_code';
--    select proc_smu_cluster_role() into iscluster;
--    if iscluster = 1 then
--        if (tg_op = 'DELETE') then
--            valueone := cast(old.camera_code as varchar(32));
--            valuetwo := cast(old.domain_code as varchar(32));
--        else
--            if (tg_op = 'UPDATE') then
--                valueone := cast(old.camera_code as varchar(32));
--                valuetwo := cast(old.domain_code as varchar(32));
--                if (valueone is not null or valuetwo is not null) then
--                delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
--                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
--                end if;
--            end if;
--            valueone := cast(new.camera_code as varchar(32));
--            valuetwo := cast(new.domain_code as varchar(32));
--        end if;
--        if (valueone is not null or valuetwo is not null) then
--            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo;
--            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,NULL ,NULL);
--        end if;
--    end if;
--    return null;
--end;
--$proc_write_unsync_camera_info$ language plpgsql;
--alter function proc_write_unsync_camera_info() owner to smuadmin;
--    
--drop trigger if exists tri_unsync_camera_info on tbl_smu_camera_info;
--create trigger tri_unsync_camera_info after insert or update or delete on tbl_smu_camera_info
--    for each row execute procedure proc_write_unsync_camera_info();
    
------32 tbl_smu_transparent_object
create or replace function proc_write_unsync_transparent_object() returns trigger as $proc_write_unsync_transparent_object$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_transparent_object';
    fieldone := 'transparent_id'; 
    fieldtwo := 'object_index';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.transparent_id as varchar(32));
            valuetwo := cast(old.object_index as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.transparent_id as varchar(32));
                valuetwo := cast(old.object_index as varchar(32));
                if (valueone is not null or valuetwo is not null) then
                delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.transparent_id as varchar(32));
            valuetwo := cast(new.object_index as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_transparent_object$ language plpgsql;
alter function proc_write_unsync_transparent_object() owner to smuadmin;
    
drop trigger if exists tri_unsync_transparent_object on tbl_smu_transparent_object;
create trigger tri_unsync_transparent_object after insert or update or delete on tbl_smu_transparent_object
    for each row execute procedure proc_write_unsync_transparent_object();



------THREE PK TABLES    
------33 tbl_smu_linkage_action_dev
create or replace function proc_write_unsync_linkage_action_dev() returns trigger as $proc_write_unsync_linkage_action_dev$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(64);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_linkage_action_dev';
    fieldone := 'action_id';
    fieldtwo := 'dev_code';
    fieldthree := 'dev_domain_code';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.action_id as varchar(32));
            valuetwo := cast(old.dev_code as varchar(64));
            valuethree := cast(old.dev_domain_code as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.action_id as varchar(32));
                valuetwo := cast(old.dev_code as varchar(64));
                valuethree := cast(old.dev_domain_code as varchar(32));
                if (valueone is not null or valuetwo is not null or valuethree is not null) then
                delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
                end if;
            end if;
            valueone := cast(new.action_id as varchar(32));
            valuetwo := cast(new.dev_code as varchar(64));
            valuethree := cast(new.dev_domain_code as varchar(32));            
        end if;
        if (valueone is not null or valuetwo is not null or valuethree is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
        end if;
    end if;
    return null;
end;
$proc_write_unsync_linkage_action_dev$ language plpgsql;
alter function proc_write_unsync_linkage_action_dev() owner to smuadmin;
    
drop trigger if exists tri_unsync_linkage_action_dev on tbl_smu_linkage_action_dev;
create trigger tri_unsync_linkage_action_dev after insert or update or delete on tbl_smu_linkage_action_dev
    for each row execute procedure proc_write_unsync_linkage_action_dev();    

------34 tbl_smu_linakge_action_user
create or replace function proc_write_unsync_linakge_action_user() returns trigger as $proc_write_unsync_linakge_action_user$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_linakge_action_user';
    fieldone := 'action_id';
    fieldtwo := 'user_id';
    fieldthree := 'user_domain_code';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.action_id as varchar(32));
            valuetwo := cast(old.user_id as varchar(32));
            valuethree := cast(old.user_domain_code as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.action_id as varchar(32));
                valuetwo := cast(old.user_id as varchar(32));
                valuethree := cast(old.user_domain_code as varchar(32));
                if (valueone is not null or valuetwo is not null or valuethree is not null) then
                delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
                end if;
            end if;
            valueone := cast(new.action_id as varchar(32));
            valuetwo := cast(new.user_id as varchar(32));
            valuethree := cast(new.user_domain_code as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null or valuethree is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
        end if;
    end if;
    return null;
end;
$proc_write_unsync_linakge_action_user$ language plpgsql;
alter function proc_write_unsync_linakge_action_user() owner to smuadmin;
    
drop trigger if exists tri_unsync_linakge_action_user on tbl_smu_linakge_action_user;
create trigger tri_unsync_linakge_action_user after insert or update or delete on tbl_smu_linakge_action_user
    for each row execute procedure proc_write_unsync_linakge_action_user();    
    
------35 tbl_smu_grp_dev_relation
create or replace function proc_write_unsync_grp_dev_relation() returns trigger as $proc_write_unsync_grp_dev_relation$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_grp_dev_relation';
    fieldone := 'parent_grp_id';
    fieldtwo := 'dev_code';
    fieldthree := 'domain_code';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.parent_grp_id as varchar(32));
            valuetwo := cast(old.dev_code as varchar(32));
            valuethree := cast(old.domain_code as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.parent_grp_id as varchar(32));
                valuetwo := cast(old.dev_code as varchar(32));
                valuethree := cast(old.domain_code as varchar(32));
                if (valueone is not null or valuetwo is not null or valuethree is not null) then
                delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
                end if;
            end if;
            valueone := cast(new.parent_grp_id as varchar(32));
            valuetwo := cast(new.dev_code as varchar(32));
            valuethree := cast(new.domain_code as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null or valuethree is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
        end if;
    end if;
    return null;
end;
$proc_write_unsync_grp_dev_relation$ language plpgsql;
alter function proc_write_unsync_grp_dev_relation() owner to smuadmin;
    
drop trigger if exists tri_unsync_grp_dev_relation on tbl_smu_grp_dev_relation;
create trigger tri_unsync_grp_dev_relation after insert or update or delete on tbl_smu_grp_dev_relation
    for each row execute procedure proc_write_unsync_grp_dev_relation();
    
------36 tbl_smu_dev_chanel_relation
--create or replace function proc_write_unsync_dev_chanel_relation() returns trigger as $proc_write_unsync_dev_chanel_relation$
--declare
--    iscluster integer;
--    tablename varchar(32);    
--    fieldone varchar(32);
--    valueone varchar(32);     
--    fieldtwo varchar(32);
--    valuetwo varchar(128);
--    fieldthree varchar(32);
--    valuethree varchar(32);    
--begin
--    tablename := 'tbl_smu_dev_chanel_relation';
--    fieldone := 'chanel_code';
--    fieldtwo := 'chanel_name';
--    fieldthree := 'chanel_type';
--    select proc_smu_cluster_role() into iscluster;
--    if iscluster = 1 then
--        if (tg_op = 'DELETE') then
--            valueone := cast(old.chanel_code as varchar(32));
--            valuetwo := cast(old.chanel_name as varchar(128));
--            valuethree := cast(old.chanel_type as varchar(32));
--        else
--            if (tg_op = 'UPDATE') then
--                valueone := cast(old.chanel_code as varchar(32));
--                valuetwo := cast(old.chanel_name as varchar(128));
--                valuethree := cast(old.chanel_type as varchar(32));
--                if (valueone is not null or valuetwo is not null or valuethree is not null) then
--                delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
--                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
--                end if;
--            end if;
--            valueone := cast(new.chanel_code as varchar(32));
--            valuetwo := cast(new.chanel_name as varchar(128));
--            valuethree := cast(new.chanel_type as varchar(32));
--        end if;
--        if (valueone is not null or valuetwo is not null or valuethree is not null) then
--            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
--            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
--        end if;
--    end if;
--    return null;
--end;
--$proc_write_unsync_dev_chanel_relation$ language plpgsql;
--alter function proc_write_unsync_dev_chanel_relation() owner to smuadmin;
--    
--drop trigger if exists tri_unsync_dev_chanel_relation on tbl_smu_dev_chanel_relation;
--create trigger tri_unsync_dev_chanel_relation after insert or update or delete on tbl_smu_dev_chanel_relation
--    for each row execute procedure proc_write_unsync_dev_chanel_relation();
    
------37 tbl_smu_plan_detail
create or replace function proc_write_unsync_plan_detail() returns trigger as $proc_write_unsync_plan_detail$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_plan_detail';
    fieldone := 'id';
    fieldtwo := 'start_time';
    fieldthree := 'end_time';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
            valuetwo := cast(old.start_time as varchar(32));
            valuethree := cast(old.end_time as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.id as varchar(32));
                valuetwo := cast(old.start_time as varchar(32));
                valuethree := cast(old.end_time as varchar(32));
                if (valueone is not null or valuetwo is not null or valuethree is not null) then
                delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
                end if;
            end if;
            valueone := cast(new.id as varchar(32));
            valuetwo := cast(new.start_time as varchar(32));
            valuethree := cast(new.end_time as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null or valuethree is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
        end if;
    end if;
    return null;
end;
$proc_write_unsync_plan_detail$ language plpgsql;
alter function proc_write_unsync_plan_detail() owner to smuadmin;
    
drop trigger if exists tri_unsync_plan_detail on tbl_smu_plan_detail;
create trigger tri_unsync_plan_detail after insert or update or delete on tbl_smu_plan_detail
    for each row execute procedure proc_write_unsync_plan_detail();
    
------38 tbl_smu_forward_channel
create or replace function proc_write_unsync_forward_channel() returns trigger as $proc_write_unsync_forward_channel$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_forward_channel';
    fieldone := 'stream_type';
    fieldtwo := 'channel_code';
    fieldthree := 'channel_domain_code';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.stream_type as varchar(32));
            valuetwo := cast(old.channel_code as varchar(64));
            valuethree := cast(old.channel_domain_code as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.stream_type as varchar(32));
                valuetwo := cast(old.channel_code as varchar(64));
                valuethree := cast(old.channel_domain_code as varchar(32));
                if (valueone is not null or valuetwo is not null or valuethree is not null) then
                delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
                end if;
            end if;
            valueone := cast(new.stream_type as varchar(32));
            valuetwo := cast(new.channel_code as varchar(64));
            valuethree := cast(new.channel_domain_code as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null or valuethree is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
        end if;
    end if;
    return null;
end;
$proc_write_unsync_forward_channel$ language plpgsql;
alter function proc_write_unsync_forward_channel() owner to smuadmin;
    
drop trigger if exists tri_unsync_forward_channel on tbl_smu_forward_channel;
create trigger tri_unsync_forward_channel after insert or update or delete on tbl_smu_forward_channel
    for each row execute procedure proc_write_unsync_forward_channel();
    
------39 tbl_smu_forward_node
create or replace function proc_write_unsync_forward_node() returns trigger as $proc_write_unsync_forward_node$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_forward_node';
    fieldone := 'domian_code';
    fieldtwo := 'node_code';
    fieldthree := 'forward_type';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.domian_code as varchar(32));
            valuetwo := cast(old.node_code as varchar(32));
            valuethree := cast(old.forward_type as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.domian_code as varchar(32));
                valuetwo := cast(old.node_code as varchar(32));
                valuethree := cast(old.forward_type as varchar(32));
                if (valueone is not null or valuetwo is not null or valuethree is not null) then
                delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
                end if;
            end if;
            valueone := cast(new.domian_code as varchar(32));
            valuetwo := cast(new.node_code as varchar(32));
            valuethree := cast(new.forward_type as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null or valuethree is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
        end if;
    end if;
    return null;
end;
$proc_write_unsync_forward_node$ language plpgsql;
alter function proc_write_unsync_forward_node() owner to smuadmin;
    
drop trigger if exists tri_unsync_forward_node on tbl_smu_forward_node;
create trigger tri_unsync_forward_node after insert or update or delete on tbl_smu_forward_node
    for each row execute procedure proc_write_unsync_forward_node();
    
------40 tbl_smu_shadow_dev
create or replace function proc_write_unsync_shadow_dev() returns trigger as $proc_write_unsync_shadow_dev$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_shadow_dev';
    fieldone := 'shadow_dev_code';
    fieldtwo := 'shadow_dev_domain_code';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.shadow_dev_code as varchar(32));
            valuetwo := cast(old.shadow_dev_domain_code as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.shadow_dev_code as varchar(32));
                valuetwo := cast(old.shadow_dev_domain_code as varchar(32));
                if (valueone is not null or valuetwo is not null) then
                delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);            
                end if;
            end if;
            valueone := cast(new.shadow_dev_code as varchar(32));
            valuetwo := cast(new.shadow_dev_domain_code as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone and  field_two=fieldtwo and value_two=valuetwo;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'',''||valuetwo||'',NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_shadow_dev$ language plpgsql;
alter function proc_write_unsync_shadow_dev() owner to smuadmin;
    
drop trigger if exists tri_unsync_shadow_dev on tbl_smu_shadow_dev;
create trigger tri_unsync_shadow_dev after insert or update or delete on tbl_smu_shadow_dev
    for each row execute procedure proc_write_unsync_shadow_dev();
    
    
------41 tbl_smu_qd_plan
create or replace function proc_write_unsync_qd_plan() returns trigger as $proc_write_unsync_qd_plan$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_qd_plan';
    fieldone := 'camera_code'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.camera_code as varchar(32));
        else
            valueone := cast(new.camera_code as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_qd_plan$ language plpgsql;
alter function proc_write_unsync_qd_plan() owner to smuadmin;
    
drop trigger if exists tri_unsync_qd_plan on tbl_smu_qd_plan;
create trigger tri_unsync_qd_plan after insert or update or delete on tbl_smu_qd_plan
    for each row execute procedure proc_write_unsync_qd_plan();
    
------42 tbl_smu_qd_rule_group
create or replace function proc_write_unsync_qd_rule_group() returns trigger as $proc_write_unsync_qd_rule_group$
declare
    iscluster integer;
    tablename varchar(32);    
    fieldone varchar(32);
    valueone varchar(32);     
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32);    
begin
    tablename := 'tbl_smu_qd_rule_group';
    fieldone := 'camera_code'; 
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.camera_code as varchar(32));
        else
            valueone := cast(new.camera_code as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',NULL ,NULL ,NULL ,NULL);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_qd_rule_group$ language plpgsql;
alter function proc_write_unsync_qd_rule_group() owner to smuadmin;
    
drop trigger if exists tri_unsync_qd_rule_group on tbl_smu_qd_rule_group;
create trigger tri_unsync_qd_rule_group after insert or update or delete on tbl_smu_qd_rule_group
    for each row execute procedure proc_write_unsync_qd_rule_group();

------ 43 tbl_smu_gis_mapfile
create or replace function proc_write_unsync_gis_mapfile() returns trigger as $proc_write_unsync_gis_mapfile$
declare
    iscluster integer;
    tablename varchar(32);  
    fieldone varchar(32);
    valueone varchar(32);   
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32); 
begin
    tablename := 'tbl_smu_gis_mapfile';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',null ,null ,null ,null);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_gis_mapfile$ language plpgsql;
alter function proc_write_unsync_gis_mapfile() owner to smuadmin;
    
drop trigger if exists tri_unsync_gis_mapfile on tbl_smu_gis_mapfile;
create trigger tri_unsync_gis_mapfile after insert or update or delete on tbl_smu_gis_mapfile
    for each row execute procedure proc_write_unsync_gis_mapfile(); 
    
-----   44 tbl_smu_gis_dev
create or replace function proc_write_unsync_gis_dev() returns trigger as $proc_write_unsync_gis_dev$
declare
    iscluster integer;
    tablename varchar(32);  
    fieldone varchar(32);
    valueone varchar(32);   
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32); 
begin
    tablename := 'tbl_smu_gis_dev';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',null ,null ,null ,null);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_gis_dev$ language plpgsql;
alter function proc_write_unsync_gis_dev() owner to smuadmin;
    
drop trigger if exists tri_unsync_gis_dev on tbl_smu_gis_dev;
create trigger tri_unsync_gis_dev after insert or update or delete on tbl_smu_gis_dev
    for each row execute procedure proc_write_unsync_gis_dev(); 
    
----- 45 tbl_smu_gis_maplink
create or replace function proc_write_unsync_gis_maplink() returns trigger as $proc_write_unsync_gis_maplink$
declare
    iscluster integer;
    tablename varchar(32);  
    fieldone varchar(32);
    valueone varchar(32);   
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32); 
begin
    tablename := 'tbl_smu_gis_maplink';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',null ,null ,null ,null);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_gis_maplink$ language plpgsql;
alter function proc_write_unsync_gis_maplink() owner to smuadmin;
    
drop trigger if exists tri_unsync_gis_maplink on tbl_smu_gis_maplink;
create trigger tri_unsync_gis_maplink after insert or update or delete on tbl_smu_gis_maplink
    for each row execute procedure proc_write_unsync_gis_maplink(); 

----- 46 tbl_smu_gis_map_bookmark
create or replace function proc_write_unsync_gis_map_bookmark() returns trigger as $proc_write_unsync_gis_map_bookmark$
declare
    iscluster integer;
    tablename varchar(32);  
    fieldone varchar(32);
    valueone varchar(32);   
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32); 
begin
    tablename := 'tbl_smu_gis_map_bookmark';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',null ,null ,null ,null);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_gis_map_bookmark$ language plpgsql;
alter function proc_write_unsync_gis_map_bookmark() owner to smuadmin;
    
drop trigger if exists tri_unsync_gis_map_bookmark on tbl_smu_gis_map_bookmark;
create trigger tri_unsync_gis_map_bookmark after insert or update or delete on tbl_smu_gis_map_bookmark
    for each row execute procedure proc_write_unsync_gis_map_bookmark();    

----- 47 tbl_smu_gis_user_defaultmap
create or replace function proc_write_unsync_gis_user_defaultmap() returns trigger as $proc_write_unsync_gis_user_defaultmap$
declare
    iscluster integer;
    tablename varchar(32);  
    fieldone varchar(32);
    valueone varchar(32);   
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32); 
begin
    tablename := 'tbl_smu_gis_user_defaultmap';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',null ,null ,null ,null);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_gis_user_defaultmap$ language plpgsql;
alter function proc_write_unsync_gis_user_defaultmap() owner to smuadmin;
    
drop trigger if exists tri_unsync_gis_user_defaultmap on tbl_smu_gis_user_defaultmap;
create trigger tri_unsync_gis_user_defaultmap after insert or update or delete on tbl_smu_gis_user_defaultmap
    for each row execute procedure proc_write_unsync_gis_user_defaultmap(); 
    
----- 48 tbl_smu_gis_map_cache
create or replace function proc_write_unsync_gis_map_cach() returns trigger as $proc_write_unsync_gis_map_cach$
declare
    iscluster integer;
    tablename varchar(32);  
    fieldone varchar(32);
    valueone varchar(32);   
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32); 
begin
    tablename := 'tbl_smu_gis_map_cache';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',null ,null ,null ,null);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_gis_map_cach$ language plpgsql;
alter function proc_write_unsync_gis_map_cach() owner to smuadmin;
    
drop trigger if exists tri_unsync_gis_map_cache on tbl_smu_gis_map_cache;
create trigger tri_unsync_gis_map_cache after insert or update or delete on tbl_smu_gis_map_cache
    for each row execute procedure proc_write_unsync_gis_map_cach();    
    
----- 49 tbl_smu_gis_style
create or replace function proc_write_unsync_gis_style() returns trigger as $proc_write_unsync_gis_style$
declare
    iscluster integer;
    tablename varchar(32);  
    fieldone varchar(32);
    valueone varchar(32);   
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32); 
begin
    tablename := 'tbl_smu_gis_style';
    fieldone := 'id';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
        else
            valueone := cast(new.id as varchar(32));
        end if;
        if (valueone is not null) then
            delete from tbl_unsync_table where table_name=tablename and value_one=valueone and field_one=fieldone;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',null ,null ,null ,null);
        end if;
    end if;
    return null;
end;
$proc_write_unsync_gis_style$ language plpgsql;
alter function proc_write_unsync_gis_style() owner to smuadmin;
    
drop trigger if exists tri_unsync_gis_style on tbl_smu_gis_style;
create trigger tri_unsync_gis_style after insert or update or delete on tbl_smu_gis_style
    for each row execute procedure proc_write_unsync_gis_style();   

----- 50 delete main_dev related database
create or replace function delete_main_dev(devCode varchar(32), localDomainCode varchar(32))
returns boolean as
$body$
declare
result boolean;
begin
    delete from tbl_smu_dev_route where dev_code = devCode;
    delete from tbl_smu_shadow_dev where shadow_dev_code = devCode and shadow_dev_domain_code = localDomainCode;
    delete from tbl_smu_dev_chanel_relation where dev_code = devCode;
    
    return result;
end;
$body$ language plpgsql;
alter function delete_main_dev(devCode varchar(32), localDomainCode varchar(32)) owner to smuadmin;

----- tbl_smu_linkage_action_user -----
create or replace function delete_linkage_action_user(alarmInCode varchar(32))
returns boolean as
$body$
declare
    id integer;
    actionId integer;
begin
    for id in select id from tbl_smu_alarm_linkage where alarm_in_code = alarmInCode loop
        for actionId in select id from tbl_smu_alarm_linkage_action where alarm_linakge_id = id loop
            delete from tbl_smu_linakge_action_user where action_id = actionId;
        end loop;
    end loop;
return true;
end;
$body$ language plpgsql;
alter function delete_linkage_action_user(alarmInCode varchar(32)) owner to smuadmin;


----- tbl_smu_linkage_action_dev -----
create or replace function delete_linkage_action_dev(alarmInCode varchar(32))
returns boolean as
$body$
declare
    id integer;
    actionId integer;
begin
    for id in select id from tbl_smu_alarm_linkage where alarm_in_code = alarmInCode loop
        for actionId in select id from tbl_smu_alarm_linkage_action where alarm_linakge_id = id loop
            delete from tbl_smu_linkage_action_dev where action_id = actionId;
        end loop;
    end loop;
return true;
end;
$body$ language plpgsql;
alter function delete_linkage_action_dev(alarmInCode varchar(32)) owner to smuadmin;

----- tbl_smu_alarm_linkage_action -----
create or replace function delete_linkage_action(alarmInCode varchar(32))
returns boolean as
$body$
declare
    id integer;
begin
    for id in select id from tbl_smu_alarm_linkage where alarm_in_code = alarmInCode loop
        delete from tbl_smu_linkage_action_dev where action_id = id;
    end loop;
return true;
end;
$body$ language plpgsql;
alter function delete_linkage_action(alarmInCode varchar(32)) owner to smuadmin;


----- tbl_smu_subscribe_alarm_level -----
create or replace function delete_sub_alarm_level(alarmInCode varchar(32))
returns boolean as
$body$
declare
    id integer;
begin
    for id in select id from tbl_smu_alarm_subscribe where alarm_in_code = alarmInCode loop
        delete from tbl_smu_subscribe_alarm_level where action_id = id;
    end loop;
return true;
end;
$body$ language plpgsql;
alter function delete_sub_alarm_level(alarmInCode varchar(32)) owner to smuadmin;

----- tbl_smu_subscribe_alarm_type ----
create or replace function delete_sub_alarm_type(alarmInCode varchar(32))
returns boolean as
$body$
declare
    id integer;
begin
    for id in select id from tbl_smu_alarm_subscribe where alarm_in_code = alarmInCode loop
        delete from tbl_smu_subscribe_alarm_type where action_id = id;
    end loop;
return true;
end;
$body$ language plpgsql;
alter function delete_sub_alarm_type(alarmInCode varchar(32)) owner to smuadmin;


----- 51 delete video sub device related database -----
create or replace function delete_video_sub_dev(videoSubDev varchar(32), localDomainCode varchar(32))
returns boolean as
$body$
declare
result boolean;
begin
    select delete_linkage_action_user(videoSubDev) into result;
    select delete_linkage_action_dev(videoSubDev) into result;
    select delete_linkage_action(videoSubDev) into result;
    select delete_sub_alarm_level(videoSubDev) into result;
    select delete_sub_alarm_type(videoSubDev) into result;
    
    
    delete from tbl_smu_alarm_area_dev where alarm_in_code = videoSubDev;
    delete from tbl_smu_alarm_linkage where alarm_in_code = videoSubDev;
    delete from tbl_smu_alarm_subscribe where alarm_in_code = videoSubDev and id <> 1;
    delete from tbl_smu_grp_dev_relation where dev_code = videoSubDev and domain_code = localDomainCode;
    delete from tbl_smu_camera_info where camera_code = videoSubDev and domain_code = localDomainCode;
    delete from tbl_smu_shadow_dev where shadow_dev_code = videoSubDev and shadow_dev_domain_code = localDomainCode;
    delete from tbl_smu_snapshot where camera_code = videoSubDev;    
return result;
end;
$body$ language plpgsql;
alter function delete_video_sub_dev(videoSubDev varchar(32), localDomainCode varchar(32)) owner to smuadmin;

----- 52 delete alarm in device related databse -----
create or replace function delete_alarm_in_dev(alarmInCode varchar(32))
returns boolean as
$body$
declare
result boolean;
begin
    select delete_linkage_action_user(alarmInCode) into result;
    select delete_linkage_action_dev(alarmInCode) into result;
    select delete_linkage_action(alarmInCode) into result;
    select delete_sub_alarm_level(alarmInCode) into result;
    select delete_sub_alarm_type(alarmInCode) into result;
    
    
    delete from tbl_smu_alarm_area_dev where alarm_in_code = alarmInCode;
    delete from tbl_smu_alarm_linkage where alarm_in_code = alarmInCode;
    delete from tbl_smu_alarm_subscribe where alarm_in_code = alarmInCode and id <> 1;  
return result;
end;
$body$ language plpgsql;
alter function delete_alarm_in_dev(subDevCode varchar(32)) owner to smuadmin;
    
------47 tbl_smu_media_white_list
create or replace function proc_write_unsync_media_white_list() returns trigger as $proc_write_unsync_media_white_list$
declare
    iscluster integer;
    tablename varchar(32);  
    fieldone varchar(32);
    valueone varchar(32);   
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32); 
begin
    tablename := 'tbl_smu_media_white_list';
    fieldone := 'user_id';
    fieldtwo := 'white_list_id';
    fieldthree := 'domain_code';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.user_id as varchar(32));
            valuetwo := cast(old.white_list_id as varchar(32));
            valuethree := cast(old.domain_code as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.user_id as varchar(32));
                valuetwo := cast(old.white_list_id as varchar(32));
                valuethree := cast(old.domain_code as varchar(32));
                if (valueone is not null or valuetwo is not null or valuethree is not null) then
                delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
                end if;
            end if;
            valueone := cast(new.user_id as varchar(32));
            valuetwo := cast(new.white_list_id as varchar(32));
            valuethree := cast(new.domain_code as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null or valuethree is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
        end if;
    end if;
    return null;
end;
$proc_write_unsync_media_white_list$ language plpgsql;
alter function proc_write_unsync_media_white_list() owner to smuadmin;
    
drop trigger if exists tri_unsync_media_white_list on tbl_smu_media_white_list;
create trigger tri_unsync_media_white_list after insert or update or delete on tbl_smu_media_white_list
    for each row execute procedure proc_write_unsync_media_white_list();
    
------48 tbl_smu_media_white_list_detail
create or replace function proc_write_unsync_media_white_list_detail() returns trigger as $proc_write_unsync_media_white_list_detail$
declare
    iscluster integer;
    tablename varchar(32);  
    fieldone varchar(32);
    valueone varchar(32);   
    fieldtwo varchar(32);
    valuetwo varchar(32);
    fieldthree varchar(32);
    valuethree varchar(32); 
begin
    tablename := 'tbl_smu_media_white_list_detail';
    fieldone := 'id';
    fieldtwo := 'camera_code';
    fieldthree := 'domain_code';
    select proc_smu_cluster_role() into iscluster;
    if iscluster = 1 then
        if (tg_op = 'DELETE') then
            valueone := cast(old.id as varchar(32));
            valuetwo := cast(old.camera_code as varchar(32));
            valuethree := cast(old.domain_code as varchar(32));
        else
            if (tg_op = 'UPDATE') then
                valueone := cast(old.id as varchar(32));
                valuetwo := cast(old.camera_code as varchar(32));
                valuethree := cast(old.domain_code as varchar(32));
                if (valueone is not null or valuetwo is not null or valuethree is not null) then
                delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
                insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
                end if;
            end if;
            valueone := cast(new.id as varchar(32));
            valuetwo := cast(new.camera_code as varchar(32));
            valuethree := cast(new.domain_code as varchar(32));
        end if;
        if (valueone is not null or valuetwo is not null or valuethree is not null) then
            delete from tbl_unsync_table where table_name=tablename and field_one=fieldone and value_one=valueone and  field_two=fieldtwo and value_two=valuetwo and field_three=fieldthree and  value_three=valuethree;
            insert into tbl_unsync_table(table_name,field_one,value_one,field_two,value_two,field_three,value_three) values (''||tablename||'', ''||fieldone||'',''||valueone||'',''||fieldtwo||'' ,''||valuetwo||'' ,''||fieldthree||'' ,''||valuethree||'');
        end if;
    end if;
    return null;
end;
$proc_write_unsync_media_white_list_detail$ language plpgsql;
alter function proc_write_unsync_media_white_list_detail() owner to smuadmin;
    
drop trigger if exists tri_unsync_media_white_list_detail on tbl_smu_media_white_list_detail;
create trigger tri_unsync_media_white_list_detail after insert or update or delete on tbl_smu_media_white_list_detail
    for each row execute procedure proc_write_unsync_media_white_list_detail();


--适配升级添加日志打印，该打印请保持在文件的最后，新增的存储过程函数请放置在该处之前
do $$
    begin
        --此处打印为sql执行成功的标志，该关键字GAUSSDB_UPG_SUCCEED在本文件其他打印不得使用
        raise notice '==================*GAUSSDB_UPG_SUCCEED*=======================';
    end;
$$;