create or replace function delete_alarm_linkage(alarmInCode varchar(32))
returns boolean as
$body$
declare
	alarmLinkageId int;
	actionId int;
	result boolean;
begin
	for alarmLinkageId in select id from tbl_scu_alarm_linkage where alarm_in_code = alarmInCode loop
		for actionId in select id from tbl_scu_alarm_linkage_action where alarm_linakge_id = alarmLinkageId loop
			select delete_alarm_linkage_action(actionID) into result;
		end loop;
		delete from tbl_scu_alarm_linkage where id = alarmLinkageId;
	end loop;
 return result;
end;
$body$ language plpgsql;


create or replace function delete_alarm_linkage_action(actionID int)
returns boolean as
$body$
begin
	delete from tbl_scu_linkage_action_dev where action_id = actionID;
	delete from tbl_scu_linkage_action_user where action_id = actionID;
	delete from tbl_scu_alarm_linkage_action where id = actionID;
 return true;
end;
$body$ language plpgsql;

create or replace function delete_cruise_plan(cameraCode varchar(32))
returns boolean as
$body$
declare
	planID int;
	eventPlanID int;
begin
	for planID in select a.id from tbl_scu_plan a, tbl_scu_event_plan b, tbl_scu_cruise_event c where a.event_plan_id = b.id and  b.event_id=c.id and c.camera_code = cameraCode loop
		delete from tbl_scu_plan where id = planID;
	end loop;
	
	for eventPlanID in select b.id from tbl_scu_event_plan b, tbl_scu_cruise_event c where b.event_id=c.id and c.camera_code = cameraCode loop
		delete from tbl_scu_event_plan where id = eventPlanID;
	end loop;
	
	delete from tbl_scu_cruise_event where camera_code=cameraCode;
 return true;
end;
$body$ language plpgsql;

create or replace function delete_motion_detection(cameraCode varchar(32))
returns boolean as
$body$
declare
	motionDetectionId int;
	areaID int;
begin
	for motionDetectionId in select id from tbl_scu_motion_detection where camera_code = cameraCode loop
		delete from tbl_scu_area where area_type = 0 and parent_id = motionDetectionId;
	end loop;
	delete from tbl_scu_motion_detection where camera_code = cameraCode;
 return true;
end;
$body$ language plpgsql;

create or replace function delete_video_mask(cameraCode varchar(32))
returns boolean as
$body$
declare
	maskId int;
	areaID int;
begin
	for maskId in select id from tbl_scu_video_mask where camera_code = cameraCode loop
		delete from tbl_scu_area where area_type = 2 and parent_id = maskId;
	end loop;
	delete from tbl_scu_video_mask where camera_code = cameraCode;
 return true;
end;
$body$ language plpgsql;

create or replace function delete_hide_alarm(cameraCode varchar(32))
returns boolean as
$body$
declare
	hideAlarmId int;
	areaID int;
begin
	for hideAlarmId in select id from tbl_scu_video_hide_alarm where camera_code = cameraCode loop
		delete from tbl_scu_area where area_type = 1 and parent_id = hideAlarmId;
	end loop;
	delete from tbl_scu_video_hide_alarm where camera_code = cameraCode;
 return true;
end;
$body$ language plpgsql;


create or replace function delete_record_plan(cameraCode varchar(32))
returns boolean as
$body$
declare
	planID varchar(32);
begin
	for planID in select strategy_id from tbl_device_strategy_map where device_id = cameraCode loop
		delete from tbl_record_strategy where id = planID;
	end loop;
	delete from tbl_device_strategy_map where device_id = cameraCode;
 return true;
end;
$body$ language plpgsql;

create or replace function delete_backup_plan(cameraCode varchar(32))
returns boolean as
$body$
declare
	planID int;
begin
	for planID in select id from tbl_mbu_backup_plan where camera_code = cameraCode loop
		delete from tbl_mbu_time_span where backup_plan_id = planID;
	end loop;
	delete from tbl_mbu_backup_plan where camera_code = cameraCode;
 return true;
end;
$body$ language plpgsql;

create or replace function delete_metadata_backup_plan(cameraCode varchar(32))
returns boolean as
$body$
declare
	planID int;
begin
	for planID in select id from tbl_metadata_backup_plan where camera_code = cameraCode loop
		delete from tbl_metadata_time_span where backup_plan_id = planID;
	end loop;
	delete from tbl_metadata_backup_plan where camera_code = cameraCode;
 return true;
end;
$body$ language plpgsql;

create or replace function delete_voice_channel(voiceCode varchar(32))
returns boolean as
$body$
declare
	voiceParaId int;
begin
	for voiceParaId in select voice_para_id from tbl_scu_voice_channel where voice_code = voiceCode loop
		delete from tbl_scu_voice_para where id = voiceParaId;
	end loop;
	delete from tbl_scu_voice_channel where voice_code = voiceCode;
 return true;
end;
$body$ language plpgsql;


create or replace function delete_video_channel(cameraCode varchar(32))
returns boolean as
$body$
declare
    snapTblNum int;
    result boolean;
begin
    select delete_record_plan(cameraCode) into result;
    select delete_backup_plan(cameraCode) into result;
    select delete_metadata_backup_plan(cameraCode) into result;
    select delete_hide_alarm(cameraCode) into result;
    select delete_video_mask(cameraCode) into result;
    select delete_motion_detection(cameraCode) into result;
    select delete_cruise_plan(cameraCode) into result;
    select delete_alarm_linkage(cameraCode) into result;
    delete from tbl_scu_video_stream where camera_code = cameraCode;
    delete from tbl_scu_snap_para where camera_code = cameraCode;
    delete from tbl_scu_ptz_para where camera_code = cameraCode;
    delete from tbl_scu_osd_time where camera_code = cameraCode;
    delete from tbl_scu_osd_name where camera_code = cameraCode;
    delete from tbl_scu_ptz_preset where camera_code = cameraCode;
    delete from tbl_scu_guard_position where camera_code = cameraCode;
    delete from tbl_scu_cruise_track where camera_code = cameraCode;
    delete from tbl_scu_track_point where camera_code = cameraCode;
    delete from tbl_device_record_parameter where device_id = cameraCode;
    delete from tbl_scu_video_in_channel where camera_code = cameraCode;
    delete from tbl_event_record_task where device_id = cameraCode;
    delete from tbl_scu_qd_plan where camera_code = cameraCode;
    delete from tbl_scu_qd_rule_group where camera_code = cameraCode;
    delete from tbl_scu_shadow_dev where shadow_dev_code = cameraCode;
    delete from tbl_mbu_backup_task where camera_code = cameraCode;
    delete from tbl_mbu_camera_backup_cfg where camera_code = cameraCode;
    delete from tbl_redundance_time where camera_code = cameraCode;
    delete from tbl_device_metadata_subscribeinfo where camera_code = cameraCode;
 return result;
end;
$body$ language plpgsql;


create or replace function delete_main_device(devCode varchar(32))
returns boolean as
$body$
declare
	cameraCode varchar(32);
	voiceCode varchar(32);
	alarmInCode varchar(32);
	result boolean;
begin
	for cameraCode in select camera_code from tbl_scu_video_in_channel where parent_code = devCode loop
		select delete_video_channel(cameraCode) into result;
	end loop;
	
	for voiceCode in select voice_code from tbl_scu_voice_channel where parent_code = devCode loop
		select delete_voice_channel(voiceCode) into result;
	end loop;
	
	for alarmInCode in select alarm_in_code from tbl_scu_alarm_in where parent_code = devCode loop
		select delete_alarm_linkage(alarmInCode) into result;
	end loop;
	
	delete from tbl_scu_alarm_in where parent_code = devCode;
	delete from tbl_scu_alarm_out where parent_code = devCode;
	delete from tbl_scu_offline_cfg where parent_code = devCode;
	delete from tbl_scu_serial where parent_code = devCode;
	delete from tbl_scu_shadow_dev where shadow_dev_code = devCode;
	delete from tbl_scu_main_dev_info where dev_code = devCode;
	return result;
end;
$body$ language plpgsql;



alter function delete_alarm_linkage(alarmInCode varchar(32)) owner to center;
alter function delete_alarm_linkage_action(actionID int) owner to center;
alter function delete_cruise_plan(cameraCode varchar(32)) owner to center;
alter function delete_motion_detection(cameraCode varchar(32)) owner to center;
alter function delete_video_mask(cameraCode varchar(32)) owner to center;
alter function delete_hide_alarm(cameraCode varchar(32)) owner to center;
alter function delete_record_plan(cameraCode varchar(32)) owner to center;
alter function delete_backup_plan(cameraCode varchar(32)) owner to center;
alter function delete_metadata_backup_plan(cameraCode varchar(32)) owner to center;
alter function delete_voice_channel(voiceCode varchar(32)) owner to center;
alter function delete_video_channel(cameraCode varchar(32)) owner to center;
alter function delete_main_device(devCode varchar(32)) owner to center;

create or replace function update_ipc_track(cameraCode varchar(32), parentCode varchar(32), nodeCode varchar(32), startTime varchar(20), endTime varchar(20))
returns boolean as
$body$
declare
	num int;
	result boolean;
begin
	result := true;
	select count(id) into num from tbl_ipc_track where camera_code = cameraCode and node_code = nodeCode;
	if num < 1 then
		insert into tbl_ipc_track(camera_code,parent_code,node_code,start_time,end_time) values (cameraCode, parentCode, nodeCode, startTime, endTime);
	else
		update tbl_ipc_track set start_time = startTime, end_time = endTime where camera_code = cameraCode and node_code = nodeCode and (start_time != startTime or end_time != endTime);
	end if;
	
 return result;
end;
$body$ language plpgsql;
alter function update_ipc_track(cameraCode varchar(32), parentCode varchar(32), nodeCode varchar(32), startTime varchar(20), endTime varchar(20)) owner to center;	

create or replace function add_ipc_track() returns trigger as $tri_add_video_channel$
	declare
	nvrCode varchar(32);
	num int;
    begin
		select nvr_code into nvrCode from tbl_scu_main_dev_info where dev_code = new.parent_code;
        num := 0;
		select count(id) into num from tbl_ipc_track where camera_code = new.camera_code and node_code=nvrCode;
		
		if num < 1 then
			insert into tbl_ipc_track(camera_code,parent_code,node_code,start_time,end_time) values (new.camera_code, new.parent_code, nvrCode, '0', '0');
		end if;

		return new;
    end;
$tri_add_video_channel$ language plpgsql;

drop trigger if exists tri_add_video_channel on tbl_scu_video_in_channel;
create trigger tri_add_video_channel after insert on tbl_scu_video_in_channel
    for each row execute procedure add_ipc_track();
alter function add_ipc_track() owner to center;	
	
create or replace function add_ipc_track_after_shift() returns trigger as $tri_shit_main_dev$
	declare
	cameraCode varchar(32);
	num int;
    begin
		if new.nvr_code != old.nvr_code then
			num := 0;
			for cameraCode in select camera_code from tbl_scu_video_in_channel where parent_code = new.dev_code loop
				select count(id) into num from tbl_ipc_track where camera_code = cameraCode and node_code=new.nvr_code;
				if num < 1 then
					insert into tbl_ipc_track(camera_code,parent_code,node_code,start_time,end_time) values (cameraCode, new.dev_code, new.nvr_code, '0', '0');
				end if;
			end loop; 
		end if;
		return new;
    end;
$tri_shit_main_dev$ language plpgsql;

drop trigger if exists tri_shit_main_dev on tbl_scu_main_dev_info;
create trigger tri_shit_main_dev after update on tbl_scu_main_dev_info
    for each row execute procedure add_ipc_track_after_shift();
alter function add_ipc_track_after_shift() owner to center;





--适配升级添加日志打印，该打印请保持在文件的最后，新增的存储过程函数请放置在该处之前
do $$
    begin
        --此处打印为sql执行成功的标志，该关键字GAUSSDB_UPG_SUCCEED在本文件其他打印不得使用
        raise notice '==================*GAUSSDB_UPG_SUCCEED*=======================';
    end;
$$;