#!/bin/sh
hostip=$(/sbin/ifconfig | grep inet | head -n1 | awk -F" " '{print $2}')
function logBak()
{
	mnt_path=`mount | grep nfs | grep mnt |  awk -F' ' '{ print $3  }'`
	if [ "$mnt_path" == "" ]; then
		return
	fi
		
	path="/home/ivs_$1"
	pre_bak_path="$mnt_path/ivs_$1_bak"

	bak_path="$pre_bak_path/$hostip"
	mkdir -p $bak_path
	tmp=$(ls $path/log/run/*.zip 2>/dev/null)
	if [ $? -eq 0 ];then
		mv $(echo $tmp) $bak_path 2>/dev/null
	fi
	tmp=$(ls $path/log/debug/*.zip 2>/dev/null)
	if [ $? -eq 0 ];then
		mv $(echo $tmp) $bak_path 2>/dev/null
	fi
	if [ $1 = "mu" ];then
		tmp=$(ls $path/log/rtsp/debug/*.zip 2>/dev/null)
		mv $(echo $tmp) $bak_path 2>/dev/null
	fi
}

function rmBakLog()
{
	mnt_path=`mount | grep nfs | grep mnt |  awk -F' ' '{ print $3  }'`
	if [ "$mnt_path" == "" ]; then
		return
	fi
		
	pre_bak_path="$mnt_path/ivs_$1_bak"

	bak_path="$pre_bak_path/$hostip"
	tmp=$(echo $(find $bak_path/ -name "*.zip" ! -newermt "$(date '+%Y-%m-%d %H:%M:%S' --date '30 days ago')"))
	if [ "$tmp"X != X ];then
	    rm -rf $tmp
	fi
}

shell_path=$(cd $(dirname $0);pwd)
crontab -l | grep -q "log_bak.sh"
if [ $? -ne 0 ];then
	crontab -l > ./crontab.log
	echo "*/2 * * * * nohup sh $shell_path/log_bak.sh & &>/dev/null" >> ./crontab.log
	crontab < ./crontab.log
	rm -f ./crontab.log
fi

logBak smu
logBak scu
logBak cmu
logBak dcg
logBak omu
logBak mu
logBak csr
logBak imgu
rmBakLog mu
rmBakLog imgu
