#!/bin/sh

source ../common/InfoStreamDs_1.0_Patch_Common
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"
node=$1


function show_usage
{
    echo "usage: sh $(THIS_SCRIPT) [mmu_master|mmu_slave|vpu]"
}

# 输入参数检查，参数个数0
function check_param
{
    if [ $# -ne 1 ];then
        show_usage
        return 1
    fi
}

function install_patch
{
    echo "begin install all patch"
    
    # MMU主节点安装补丁

    # 安装公共配置
    echo "begin install mmu master patch for common config"
    
    # 停止imgu
    echo "begin install vpu patch for stop imgu"
    cd SCRIPT
    sh InfoStreamDs_1.0_Patch_Stop_Imgu.sh
    cd - 1>/dev/null
    echo "end instal vpu patch for stop imgu"
    
    # 安装修复ivsoper密码过期的补丁
    cd SCRIPT
    sh InfoStreamDs_1.0_Patch_Fix_Pwd_Expired.sh
    cd - 1>/dev/null
    
    # 修复core_pattern文件和定时清理core补丁
    cd SCRIPT
    sh InfoStreamDs_1.0_Patch_Fix_CorePattern.sh
    cd - 1>/dev/null
    
    # 修复中心数据库守护脚本，增加角色标识
    cd SCRIPT
    sh InfoStreamDs_1.0_Recover_CenterDB_For_Cluster_Exception.sh
    cd - 1>/dev/null
    
    # 修复9000存储nfs参数
    cd SCRIPT
    sh InfoStreamDs_1.0_Patch_Modify_Nfs_Param.sh
    cd - 1>/dev/null
    
    # 修复国标设备彻底删除后, 再添加相同互联编码失败问题InfoStreamDs_1.0_Patch_Fix_Log_Collect.sh
    cd SCRIPT
    sh InfoStreamDs_1.0_Patch_Fix_Delete_Gb_Dev.sh
    cd - 1>/dev/null
	
    # 增加日志备份功能，修复日志下载功能，增加日志从备份路径下载
    cd SCRIPT
    sh InfoStreamDs_1.0_Patch_Fix_Log_Collect.sh
    cd - 1>/dev/null
    
    # 修复NTP守护脚本
    cd SCRIPT
    sh InfoStreamDs_1.0_Recover_Ntp_Monitor.sh
    cd - 1>/dev/null
	
	# 修改存储空间按照留存期回收
    cd SCRIPT
    sh InfoStreamDs_1.0_Modify_Record_Timer_Policy.sh
    cd - 1>/dev/null
	
	# 中心数据库函数，手动迁移后start time为utc时间
    cd SCRIPT
    sh InfoStreamDs_1.0_Patch_Fix_Manual_Shift_Start_Time.sh
    cd - 1>/dev/null
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install patch success"

    
    echo "end install all patch "
}

function list_installed_patch()
{
    if [ -f /home/ivstool/bin/log_bak.sh ] && false; then
        report_module_install_status "common_config" "$STATUS_INSTALLED"
        return "$STATUS_INSTALLED" 
    else
        report_module_install_status "common_config" "$STATUS_NOT_INSTALL"
        return "$STATUS_NOT_INSTALL" 
    fi
}

if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

install_patch

echo "${PACKAGE_NAME} install success"



