#!/bin/sh

source ../common/InfoStreamDs_1.0_Patch_Common
patch_name=InfoStreamDs_1.0_Patch_Fix_Cmu
dest_path_cmu_lib=/home/ivs_cmu/lib
dest_path_cmu_services=/home/ivs_cmu/lib/services
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"


function copy_so_file_cmu
{
    if [ "`arch`" = "aarch64" ];then
        cmu_file_framework=./arm/libcmu_framework.so
		cmu_file_master=./arm/libservice_master.so
		cmu_file_watcher=./arm/libservice_watcher.so
		cmu_file_slave=./arm/libservice_slave.so
    else
        return 1
    fi
    
    backup_file $dest_path_cmu_lib/libcmu_framework.so
	backup_file $dest_path_cmu_services/libservice_master.so
	backup_file $dest_path_cmu_services/libservice_watcher.so
	backup_file $dest_path_cmu_services/libservice_slave.so
	
    cp -f $cmu_file_framework $dest_path_cmu_lib
	cp -f $cmu_file_master $dest_path_cmu_services
	cp -f $cmu_file_watcher $dest_path_cmu_services
	cp -f $cmu_file_slave $dest_path_cmu_services
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "copy files success"
}

function fix_cmu
{
    sh /home/ivstool/bin/service.sh stop cmu
    
    sleep 5s
    
    copy_so_file_cmu
    
    sh /home/ivstool/bin/service.sh start cmu
    
    #check_install_result
    if [ $? -ne 0 ]; then
        return 1
        report_error $patch_name
    fi
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "fix success"
    report_success $patch_name
}


function show_usage
{
    echo "usage: sh $0"
    echo "         sh status"
}

# 输入参数检查，参数个数0
function check_param
{
    return 0
}

function list_installed_patch()
{
    local bin_file_name="libservice_slave.so"
    local bin_file_path="${dest_path_cmu_services}/libservice_slave.so"
    local module="cmu"
    local expect_md5="$(grep -a ${bin_file_name} ./md5sum.txt | awk -F ' ' '{print $1}')"
    local actual_md5="$(md5sum ${bin_file_path} | awk -F ' ' '{print $1}')"
    if [ "$actual_md5" != "$expect_md5" ]; then
        report_module_install_status "${module}" "$STATUS_NOT_INSTALL"
        return "$STATUS_NOT_INSTALL" 
    else
        report_module_install_status "${module}" "$STATUS_INSTALLED"
        return "$STATUS_INSTALLED" 
    fi
}

# 关闭zk链接鉴权，防止zk鉴权失败
sed -i 's%.*</DigestAuthentication>%    <DigestAuthentication>false</DigestAuthentication>%' /home/ivs_cmu/config/cmu_conf.xml

if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

fix_cmu
