#!/bin/sh

source ../common/InfoStreamDs_1.0_Patch_Common
patch_name=InfoStreamDs_1.0_Patch_Fix_Dcg
dest_path_dcg=/home/ivs_dcg/lib/services
dcg_home_path=/home/ivs_dcg
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"

chmod_and_own()
{
    for f in "$@"; do
        chmod 500 "$f"
        chown ivsdcg:dcg "$f"
    done
}

function copy_so_file_dcg
{
    backup_file /home/ivs_dcg/lib/services/libdcg_service.so
    backup_file /home/ivs_dcg/lib/services/libdcg_common.so

    cp -f ./arm/libdcg_service.so /home/ivs_dcg/lib/services/
    cp -f ./arm/libdcg_common.so  /home/ivs_dcg/lib/services/
    
    chmod_and_own /home/ivs_dcg/lib/services/libdcg_common.so
    chmod_and_own /home/ivs_dcg/lib/services/libdcg_common.so

    backup_file /home/ivs_dcg/lib/adapter/libdcg_adapter_onvif.so
    backup_file /home/ivs_dcg/lib/adapter/libdcg_adapter_huawei.so
    backup_file /home/ivs_dcg/lib/adapter/libdcg_adapter_t28181.so

    cp -f ./arm/libdcg_adapter_onvif.so /home/ivs_dcg/lib/adapter/
    cp -f ./arm/libdcg_adapter_huawei.so /home/ivs_dcg/lib/adapter/
    cp -f ./arm/libdcg_adapter_t28181.so /home/ivs_dcg/lib/adapter/

    chmod_and_own /home/ivs_dcg/lib/adapter/libdcg_adapter_onvif.so
    chmod_and_own /home/ivs_dcg/lib/adapter/libdcg_adapter_huawei.so
    chmod_and_own /home/ivs_dcg/lib/adapter/libdcg_adapter_t28181.so

    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "copy files success"
}

function fix_dcg
{
    sh /home/ivstool/bin/service.sh stop dcg
    
    sleep 5s
    
    copy_so_file_dcg
    
    sh /home/ivstool/bin/service.sh start dcg
    
    #check_install_result
    if [ $? -ne 0 ]; then
        return 1
        report_error $patch_name
    fi
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "fix success"
    report_success $patch_name
}


function show_usage
{
    echo "usage: sh $0"
    echo "         sh status"
}

# 输入参数检查，参数个数0
function check_param
{
    return 0
}

function list_installed_patch()
{
    local bin_file_name="libdcg_adapter_onvif.so"
    local bin_file_path="$dcg_home_path/lib/adapter/libdcg_adapter_onvif.so"
    local module="dcg"
    local expect_md5="$(grep -a ${bin_file_name} ./md5sum.txt | awk -F ' ' '{print $1}')"
    local actual_md5="$(md5sum ${bin_file_path} | awk -F ' ' '{print $1}')"
    if [ "$actual_md5" != "$expect_md5" ]; then
        report_module_install_status "${module}" "$STATUS_NOT_INSTALL"
        return $STATUS_NOT_INSTALL
    else
        report_module_install_status "${module}" "$STATUS_INSTALLED"
        return $STATUS_INSTALLED
    fi
}


if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

fix_dcg
