#!/bin/sh

source ../common/InfoStreamDs_1.0_Patch_Common
source ./common.sh
patch_name=InfoStreamDs_1.0_Patch_Fix_Mu
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"


function copy_bin_file_to_mu
{
    local mu_config="/home/ivs_mu/config/MU.conf"
    sh /home/ivstool/bin/service.sh stop mu
    
    backup_file /home/ivs_mu/bin/ivs_mu 
    cp -f ./arm/ivs_mu /home/ivs_mu/bin/ivs_mu
    backup_file /home/ivs_mu/lib/libbsm_kernel.so

    cp -f ./arm/libbsm_kernel.so /home/ivs_mu/lib/libbsm_kernel.so
    backup_file "$mu_config"
    modify_config  "$mu_config" "AntiInterference" "1"

    if [ $? -ne 0 ]; then
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "copy ivs_mu to $dest_path failed"
        sh /home/ivstool/bin/service.sh start mu
        return 1
    fi
    
    sh /home/ivstool/bin/service.sh start mu
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "copy ivs_mu success"
}

function copy_bin_file_to_imgu
{
    sh /home/ivstool/bin/service.sh stop imgu
    
    backup_file /home/ivs_imgu/lib/libbsm_kernel.so
    cp -f ./arm/libbsm_kernel.so /home/ivs_imgu/lib/libbsm_kernel.so
    
    sh /home/ivstool/bin/service.sh start imgu
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "copy ivs_imgu success"
}

function fix_mu
{
    copy_bin_file_to_imgu
    copy_bin_file_to_mu
    
    
    if [ $? -ne 0 ];then
        report_error $patch_name
        return $?
    fi
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install $patch_name success."
    report_success $patch_name
}

function list_installed_patch()
{
    local bin_file_name="ivs_mu"
    local bin_file_path="/home/ivs_mu/bin/ivs_mu"
    local module="mu"
    local expect_md5="$(grep -a ${bin_file_name} ./md5sum.txt | awk -F ' ' '{print $1}')"
    local actual_md5="$(md5sum ${bin_file_path} | awk -F ' ' '{print $1}')"
    if [ "$actual_md5" != "$expect_md5" ]; then
        report_module_install_status "${module}" "$STATUS_NOT_INSTALL"
        return $STATUS_NOT_INSTALL
    else
        report_module_install_status "${module}" "$STATUS_INSTALLED"
        return $STATUS_INSTALLED
    fi
}


if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

fix_mu
