#!/bin/sh

source ../common/InfoStreamDs_1.0_Patch_Common
work_path=$(cd $(dirname $0);pwd)
shell_path=${work_path}/install.sh
typeset -l module
module=$(basename ${work_path})
service=${module#*_}
os=arm

# 安装库
function FixLib()
{
    local install=$STATUS_INSTALLED
    for new in $(find ${work_path}/${os}/ -type f); do
        local old=/home/${module}/${new#*${os}/}
        local md5s=($(md5sum ${new} ${old} | awk '{print $1}' 2>/dev/null))
        [ -n "${md5s}" ] && [ "${md5s[0]}" == "${md5s[1]}" ] && continue
        install=$STATUS_NOT_INSTALL && [ -n "$1" ] && continue
        backup_file ${old}; cp -f ${new} ${old}
    done
    [ -n "$1" ] && report_module_install_status "${module}" "${install}"
}

# 安装配置文件
function FixConf()
{
    su -c "psql -d omu -c \"update TBL_OMU_UNIFIED_CONFIGURATIONS set CFG_LIMIT='PositiveInteger_0_2' where Cfg_Name='NTPIPC'\"" - postgres
}

function main()
{
    echo "begin install patch for ${service}"
    sh /home/ivstool/bin/service.sh stop ${service}
    sleep 5s

    FixLib
    FixConf

    sh /home/ivstool/bin/service.sh start ${service}
    echo "end install patch for ${service}"

    Log "${shell_path}" "$FUNCNAME" "$LINENO" "fix success"
    report_success ${service}
}

if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    FixLib $2
    exit 0
fi

main
