#!/bin/sh
#
# Description: 单机回退脚本 
# Athor: 肖阳阳
# Last Modified: 2021-9-17
# Revision: v0.1

source ./common/InfoStreamDs_1.0_Patch_Common
source ./common.sh

THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"
operation="rollback"

function extract_modules_from_args()
{
    local args=("$@")
    local modules=()

    for arg in "${args[@]}"; do
        if [[ ! "$arg" =~ \-.* ]]; then
            modules+=("$arg")
        fi
    done
    echo "${modules[@]}"
}

function show_usage
{
    local sep=""
    local hint=""
    local readonly SEP=", "

    echo "usage: sh $0 <node_type> all"
    echo "       sh $0 <node_type> <module> [<module> ...]"

    for node_type in "${node_types[@]}"; do
        hint="${hint}${sep}${node_type}"
        sep="$SEP"
    done
    echo -e "node_type\t: ${hint}"

    hint=""
    sep=""    
    for module in "${common_modules[@]}" "${mmu_modules[@]}"; do
        hint="${hint}${sep}${module}"
        sep="$SEP"
    done
    echo -e "mmu modules\t: ${hint} "

    hint=""
    sep=""
    for module in "${common_modules[@]}"  "${vpu_modules[@]}"; do
        hint="${hint}${sep}${module}"
        sep="$SEP"
    done    
    echo -e "vpu modules\t: ${hint}"
}

function check_param
{
    if [ $# -lt 2 ];then
        return 1
    fi
}

function do_rollback()
{
    local install_dir="$1"
    shift
    local params="$@"
    local ret=0
    local scripts=(
        "./rollback.sh"
        "./start_service.sh"
        "./stop_service.sh"
    )
    local script_not_exit="FALSE"

    cd "$install_dir"
    for script in ${scripts}; do
        if [ ! -f "$script" ]; then
            Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "error: file ${script} not exist"
            script_not_exit="TRUE"
        fi
    done
    if [ "$script_not_exit" == "TRUE" ]; then
        cd - 1>/dev/null
        return 1 
    fi

    sh ./stop_service.sh $params || ret=1
    sh ./rollback.sh $params || ret=1
    sh ./start_service.sh $params || ret=1 
    sleep 10s
    cd - 1>/dev/null
    return $ret
}

function rollback()
{
    local node=$1
    shift
    local units=("$@")
    local units_to_handle=()
    local succeed="TRUE"

    check_node_and_modules "$node" "${units[@]}"
    if [ $? -ne 0 ]; then
        echo "invalid node type or module. node type: ${node}, modules: ${units[*]}"
        return 1
    fi

    if [ "${units[0]}" == "all" ]; then
        units_to_handle=($(get_node_all_modules "$node"))
    else
        units_to_handle=(${units[@]})
    fi

    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "begin ${operation} patch. node type: $node, modules: ${units_to_handle[*]}"

    for unit in "${units_to_handle[@]}"; do 
        local dir="$(query_module_dir "$unit")"
        if [ ! -d "$dir" ]; then
            Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "${operation} directory ${dir} not exist, skip installing ${unit}"
            continue
        fi
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "${operation} ${unit} begin"
        do_rollback "$dir" "$node"
        if [ $? -ne 0 ]; then
            log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "${operation} ${unit} failed, continue to ${operation} next"
            succeed="FALSE"
        else 
            remove_module_install_info "$unit"
        fi
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "${operation} ${unit} end"
    done

    [ "$succeed" != "TRUE" ] && return 1 || return 0
}


function main()
{
    local ret=0
    Log "${THIS_SCRIPT}:${LINENO}" "COMMIT_ID" "${COMMIT_ID}" "[Version:${PACKAGE_NAME}]"
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "$0 starting..."
    check_param "$@"
    if [ $? -ne 0 ]; then
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "wrong param"
        show_usage 
        return 1
    fi

    local node="$1"
    check_node "$node"
    if [ $? -ne 0 ]; then
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "invalid node type"
        show_usage 
        return 1
    fi

    # 回滚
    rollback "$@"
    if [ $? -ne 0 ]; then
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "${operation} failed"
        report_error "$patch_name"
        return 1
    else
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "${operation} succeed"
    fi
    return 0
}

if [ "$ENABLE_DEBUG" != "true" ]; then
    main "$@"
fi