#!/bin/sh
#
# Description: 集群补丁回退脚本
# Athor: 肖阳阳
# Last Modified: 2021-9-17
# Revision: v0.1


source ./common_cluster.sh

THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"
operation="rollback"

function extract_modules_from_args()
{
    local args=("$@")
    local modules=()

    for arg in "${args[@]}"; do
        if [[ ! "$arg" =~ \-.* ]]; then
            modules+=("$arg")
        fi
    done
    echo "${modules[@]}"
}

function show_usage
{
    local sep=""
    local hint=""
    local readonly SEP=", "

    echo "usage: sh $0 <node_type> all"
    echo "       sh $0 <node_type> <module> [<module> ...]"

    for node_type in "${node_types[@]}" "all"; do
        hint="${hint}${sep}${node_type}"
        sep="$SEP"
    done
    echo -e "node_type\t: ${hint}"

    hint=""
    sep=""    
    for module in "${common_modules[@]}" "${mmu_modules[@]}"; do
        hint="${hint}${sep}${module}"
        sep="$SEP"
    done
    echo -e "mmu modules\t: ${hint} "

    hint=""
    sep=""
    for module in "${common_modules[@]}" " ${vpu_modules[@]}"; do
        hint="${hint}${sep}${module}"
        sep="$SEP"
    done    
    echo -e "vpu modules\t: ${hint}"
}

function check_param
{
    if [ $# -lt 2 ];then
        return 1
    fi
}

function rollback()
{
    local node=$1
    shift
    local units=("$@")
    local succeed="TRUE"
    local handle_nodes=()

    check_node_and_modules "$node" "${units[@]}"
    if [ $? -ne 0 ]; then
        echo "invalid node type or module. node type: ${node}, modules: ${units[*]}"
        return 1
    fi

    local mmu_installs=()
    local vpu_installs=()
    local mmu_actual_installs=()
    local vpu_actual_installs=()
    local handle_nodes=()
    case "$node" in
        "all")
            mmu_installs=("${units[@]}")
            vpu_installs=("${units[@]}")
            handle_nodes=('mmu' 'vpu')
            ;;
        "mmu")
            mmu_installs=("${units[@]}")
            handle_nodes=('mmu')
            ;;
        "vpu")
            vpu_installs=("${units[@]}")
            handle_nodes=('vpu')
            ;;
    esac

    for unit in "${mmu_installs[@]}"; do
        check_node_and_modules "mmu" "$unit"
        [ $? -eq 0 ] && mmu_actual_installs+=("$unit")
    done

    for unit in "${vpu_installs[@]}"; do
        check_node_and_modules "vpu" "$unit"
        [ $? -eq 0 ] && vpu_actual_installs+=("$unit")
    done
    
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "begin rollback all patch. node type: ${handle_nodes[*]}, modules: ${units[*]}"

    if [ "${#mmu_actual_installs[*]}" -ne 0 ]; then
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "------rollback mmu_master begin. ip: ${mmu_master_ip}"
        easy_remote_exec "$mmu_master_ip" "cd ${remote_patch_parent_dir}/${PATCH_DIR} && sh ${ROLLBACK_SCRIPT} mmu_master ${units[*]}" 
        if [ $? -ne 0 ]; then
            succeed="FALSE"
            log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "rollback mmu_master failed. ip: ${mmu_master_ip}"
            log_file ${SSH_OUTPUT_LOG}
        fi
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "------rollback mmu_master end. ip: ${mmu_master_ip}"


        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "------rollback mmu_slave begin. ip: ${mmu_slave_ip}"
        easy_remote_exec "$mmu_slave_ip" "cd ${remote_patch_parent_dir}/${PATCH_DIR} && sh ${ROLLBACK_SCRIPT} mmu_slave ${units[*]}" 
        if [ $? -ne 0 ]; then
            succeed="FALSE"
            log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "rollback mmu_slave failed. ip: ${mmu_slave_ip}"
            log_file ${SSH_OUTPUT_LOG}
        fi
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "------rollback mmu_slave end. ip: ${mmu_slave_ip}"
    fi

    if [ "${#vpu_actual_installs[*]}" -ne 0 ]; then
        for remote_ip in "${vpu_ips[@]}"; do
            log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "------rollback vpu begin. ip: ${remote_ip}"
            easy_remote_exec "$remote_ip" "cd ${remote_patch_parent_dir}/${PATCH_DIR} && sh ${ROLLBACK_SCRIPT} vpu ${units[*]}" 
            if [ $? -ne 0 ]; then
                succeed="FALSE"
                log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "rollback vpu failed. ip: ${remote_ip}"
                log_file ${SSH_OUTPUT_LOG}
            fi
            log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "------rollback vpu end. ip: ${remote_ip}"
        done
    fi

    [ "$succeed" != "TRUE" ] && return 1 || return 0
}


function main()
{
    local ret=0
    Log "${THIS_SCRIPT}:${LINENO}" "COMMIT_ID" "${COMMIT_ID}" "[Version:${PACKAGE_NAME}]"
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "$0 starting..."
    check_param "$@"
    if [ $? -ne 0 ]; then
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "wrong param"
        show_usage 
        return 1
    fi

    local node="$1"
    check_node "$node"
    if [ $? -ne 0 ]; then
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "invalid node type"
        show_usage 
        return 1
    fi
    local cluster_file="./cluster_info.ini"
    read_cluster_info "$cluster_file"
    if [ $? -ne 0 ]; then
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "invalid data, please check $cluster_file"
        return 1
    fi

    # 回滚
    rollback "$@"
    if [ $? -ne 0 ]; then
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "${operation} failed"
        report_error "$patch_name"
        return 1
    else
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO"  "${operation} succeed"
    fi
    return 0
}

if [ "$ENABLE_DEBUG" != "true" ]; then
    main "$@"
fi