#!/bin/sh
hostip=$(/sbin/ifconfig | grep inet | head -n1 | awk -F" " '{print $2}')
function logBak()
{
	path="/home/ivs_$1"
	pre_bak_path="/mnt/9000_0/ivs_$1_bak"

	bak_path="$pre_bak_path/$hostip"
	mkdir -p $bak_path
	tmp=$(ls $path/log/run/*.zip 2>/dev/null)
	if [ $? -eq 0 ];then
		mv $(echo $tmp) $bak_path 2>/dev/null
	fi
	tmp=$(ls $path/log/debug/*.zip 2>/dev/null)
	if [ $? -eq 0 ];then
		mv $(echo $tmp) $bak_path 2>/dev/null
	fi
	if [ $1 = "mu" ];then
		tmp=$(ls $path/log/rtsp/debug/*.zip 2>/dev/null)
		mv $(echo $tmp) $bak_path 2>/dev/null
	fi
	if [ $1 = "dcg" ];then
		pluginsDir=$(ls -1 $path/plugins)
		for dirName in $pluginsDir
			do
				logPath=$path/plugins/$dirName/log
				if [ -d "$logPath" ]; then
					pluginDirName="$bak_path/$dirName"
					mkdir -p $pluginDirName
					pluginRunLog=$(ls $logPath/run/*.zip 2>/dev/null)
					mv $(echo $pluginRunLog) $pluginDirName 2>/dev/null 
					pluginDbgLog=$(ls $logPath/debug/*.zip 2>/dev/null)
					mv $(echo $pluginDbgLog) $pluginDirName 2>/dev/null
				fi
			done 
	fi	
}

function rmBakLog()
{
	pre_bak_path="/mnt/9000_0/ivs_$1_bak"

	bak_path="$pre_bak_path/$hostip"
	tmp=$(echo $(find $bak_path/ -name "*.zip" ! -newermt "$(date '+%Y-%m-%d %H:%M:%S' --date '30 days ago')"))
	if [ "$tmp"X != X ];then
	    rm -rf $tmp
	fi
}

shell_path=$(cd $(dirname $0);pwd)
crontab -l | grep -q "log_bak.sh"
if [ $? -ne 0 ];then
	crontab -l > ./crontab.log
	echo "*/2 * * * * nohup sh $shell_path/log_bak.sh & &>/dev/null" >> ./crontab.log
	crontab < ./crontab.log
	rm -f ./crontab.log
fi

logBak smu
logBak scu
logBak cmu
logBak dcg
logBak omu
logBak mu
logBak csr
logBak imgu
rmBakLog mu
rmBakLog imgu
