#!/bin/sh

THIS_SCRIPT="modify_cdb_slave_info.sh"
shell_path="/home/ivstool/bin/"

master_ip=$(egrep -A1 "Database.*center" /usr/local/etc/odbc.ini | egrep -o "([0-9]{1,3}\.?){4}")
cluster_code=$(grep ClusterCode /home/ivs_cmu/config/cmu_conf.xml | awk -F'<|>' '{print $3}')
cdb_info=$(sh /home/ivs_scu/lib/zookeeper/bin/zkCli.sh -server ${master_ip}:21816 get /Cloud/${cluster_code}/CenterDB | grep MasterDB)
cdb_count=$(echo ${cdb_info} | grep -wo "${master_ip}" | wc -l)
if [ ${cdb_count} -gt 1 ];then
    master_code=$(echo ${cdb_info} | egrep -wo "\".{32}\"" | awk -F '"' '{print $2}' | head -n1)
    slave_ip=$(echo ${cdb_info} | egrep -o "([0-9]{1,3}\.){3}[0-9]{1,3}" | grep -wv "${master_ip}")
    slave=$(su - postgres -c "psql -d scu -XAtc \"select nvr_code,nvr_ip from tbl_scu_cluster_member where nvr_role=1 and nvr_ip!='${slave_ip}' and nvr_ip!='${master_ip}' limit 1;\"")
    cdb_info_mod=$(echo ${cdb_info} | sed "s/\"${master_code}\"/\"${slave%|*}\"/2;s/\"${master_ip}\"/\"${slave#*|}\"/2")
    sh /home/ivs_scu/lib/zookeeper/bin/zkCli.sh -server ${master_ip}:21816 set /Cloud/${cluster_code}/CenterDB ${cdb_info_mod}
fi

chmod 755 ${THIS_SCRIPT}
cp -pf ${THIS_SCRIPT} ${shell_path}

crontab -l | grep -q "${THIS_SCRIPT}"
if [ $? -ne 0 ];then
    crontab -l > ./crontab.log
    echo "*/30 * * * * sh ${shell_path}/${THIS_SCRIPT} &" >> ./crontab.log
    crontab < ./crontab.log
    rm -f ./crontab.log
fi
