#!/bin/bash
#
# Description: 框架单机公共文件
# Athor: 肖阳阳
# Last Modified: 2021-9-17
# Revision: v0.1

source ./patch_modules.sh

readonly E_OK=0
readonly E_ERROR=1

readonly node_types=(
    mmu_master 
    mmu_slave
    vpu
)
#
# 检查node是否合法, 以及模块是否属于node
# 
function check_node_and_modules()
{
    local node="$1"
    shift
    local units=("$@")

    [ ${#units[*]} -eq 0 ] && return 1
    if [ "$node" != "mmu_master" ] && [ "$node" != "mmu_slave" ] &&  [ "$node" != "vpu" ]; then
        return 1
    fi

    if [ "${units[0]}" == "all" ]; then
        return 0
    fi

    if [ "$node" == "mmu_master" ] || [ "$node" == "mmu_slave" ]; then
        for unit in "${units[@]}"; do
            grep -q "$unit" <<< "${common_modules[*]} ${mmu_modules[*]}"
            [ $? -ne 0 ] && return 1
        done
        return 0
    fi

    if [ "$node" == "vpu" ]; then
        for unit in "${units[@]}"; do
            grep -q "$unit" <<< "${common_modules[*]} ${vpu_modules[*]}"
            [ $? -ne 0 ] && return 1
        done
        return 0
    fi 

    return 1
}

function check_node()
{
    local node="$1"
    if [ "$node" == "mmu_master" ] || [ "$node" == "mmu_slave" ] || [ "$node" == "vpu" ] ; then
        return 0
    fi
    return 1
}

function get_node_all_modules()
{
    local node="$1"
    if [ "$node" == "mmu_master" ] || [ "$node" == "mmu_slave" ]; then
        echo "${common_modules[*]} ${mmu_modules[*]}"
    fi
    if [ "$node" == "vpu" ]; then
        echo "${common_modules[*]} ${vpu_modules[*]}"
    fi
    echo ""
}

function query_module_dir()
{
    local module="$1"
    if [ "$module" == "common_config" ]; then
        echo "${module^^}"
    else
        echo "IVS_${module^^}"
    fi
}