#!/bin/bash
#
# Description: 手动上传整个补丁目录
# Athor: 肖阳阳
# Last Modified: 2021-9-17
# Revision: v0.1
source ./common_cluster.sh

PRGNAME="$(basename $0)"
CLUSTER_INFO_FILE="./cluster_info.ini"

show_usage()
{
    echo "${PRGNAME} [check | install | delete | reinstall] [<node_ip> | all]"
}

if [[ $# -ne 2 ]]; then
    show_usage
    exit 1
fi

read_cluster_info "$CLUSTER_INFO_FILE"
[ $? -ne 0 ] && echo "invalid cluster info, please checkout the file cluster_info.ini" && exit 1

op="$1"
if [ "$2" == "all" ]; then
    node_ips=("$mmu_master_ip" "$mmu_slave_ip" "${vpu_ips[@]}")
else
    node_ips=("$2")
fi

ret=0

case "$op" in
    "check")
        for node_ip in "${node_ips[@]}"; do
            remote_exec ${node_ip} "cd ${remote_patch_parent_dir} && ls -l | grep -q ${PATCH_DIR}"
            ret=$?
            
            # 255 - SSH connection error
            if [ $ret -eq 255 ]; then
                echo "ssh to host ${node_ip} failed"
                ret=1
            elif [ $ret -eq 0 ]; then
                echo "node ${node_ip} patch status: installed"
            else
                echo "node ${node_ip} patch status: not install"
            fi
        done
        exit $ret
    ;;
    "install")
        for node_ip in "${node_ips[@]}"; do
            copy_patch_to_remote "$node_ip"
            [ $? -ne 0 ] && ret=1
        done
        exit $?
    ;;
    "delete")
        the_host_ip=""
        for node_ip in "${node_ips[@]}"; do
            if ip a | grep -q "${node_ip}"; then
                the_host_ip="$node_ip"
                continue
            fi
            remote_exec ${node_ip} "cd ${remote_patch_parent_dir} && rm -fr ./${PATCH_DIR}"
            [ $? -ne 0 ] && ret=1 && echo "delete node failed, ip is ${node_ip}"
        done
        # if [ -n "$the_host_ip" ]; then
        #     remote_exec ${the_host_ip} "cd ${remote_patch_parent_dir} && rm -fr ./${PATCH_DIR}"
        #     [ $? -ne 0 ] && ret=1 && echo "delete node failed, ip is ${node_ip}"
        # fi
        exit $ret

    ;;
    "reinstall")
        for node_ip in "${node_ips[@]}"; do
            remote_exec ${node_ip} "cd ${remote_patch_parent_dir} && rm -fr ./${PATCH_DIR}"
            [ $? -ne 0 ] && ret=1
            copy_patch_to_remote "$node_ip"
            [ $? -ne 0 ] && ret=1
        done
        exit $ret
    ;;
    *)
        show_usage
        exit 1
    ;;
esac
