# !/bin/sh

# 前提条件：
# 1）以root用户登录vpu
# 2）此补丁需要在所有的vpu节点进行安装
# 
# 操作步骤：
# 1、在所有IDS vpu节点上，执行：
#     1）sh InfoStreamDs_6.0_Patch_Fix_CorePattern.sh
#     2）根据输出情况确认脚本执行是否成功
#     3）过10分钟后，执行 cat /proc/sys/kernel/core_pattern，查看输出，若输出为以下内容，则补丁安装成功：
#         /opt/corefiles/core_%e.pid_%p.signal_%s.time_%t.host_%h

source ../../common/InfoStreamDs_6.0_Patch_Common
patch_name=InfoStreamDs_6.0_Patch_Fix_CorePattern
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"

function fix_core_pattern
{
	# 注释/etc/profile文件中ulimit -c 0
	sed -i 's/^ulimit -c 0/#ulimit -c 0/' /etc/profile
	
	cp ./fix_core_pattern.sh /home/ivstool/bin/fix_core_pattern.sh
	if [ $? -ne 0 ]; then
		Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "cp fix_core_pattern.sh error"
		return 1
	fi
	
	chmod 500 /home/ivstool/bin/fix_core_pattern.sh
	
	
	crontab -l | grep -q "fix_core_pattern.sh"
	if [ $? -ne 0 ];then
		crontab -l > ./crontab.log
		echo '*/10 * * * * /home/ivstool/bin/fix_core_pattern.sh' >> ./crontab.log
		crontab < ./crontab.log
		rm -f ./crontab.log
	fi
	
	Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install $patch_name success."
	report_success $patch_name
}

function show_usage
{
    echo "usage: sh $0"
}

# 输入参数检查，参数个数0
function check_param
{
    if [ $# -ne 0 ];then
	    show_usage
		return 1
	fi
}

check_param $@
if [ $? -ne 0 ]; then
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "check param err"
	report_error $patch_name
    exit 1
fi

fix_core_pattern
