# !/bin/sh

source ../common/InfoStreamDs_6.0_Patch_Common
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"
node=$1


function show_usage
{
    echo "usage: sh $(THIS_SCRIPT) [mmu_master|mmu_slave|vpu]"
}

# 输入参数检查，参数个数0
function check_param
{
    if [ $# -ne 0 ];then
	    show_usage
		return 1
	fi
}

function install_patch
{
	check_param $@
	if [ $? -ne 0 ]; then
		Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "check param error"
		report_error $patch_name
		exit 1
	fi

	
	echo "begin install all public patch"
	
	# 安装公共配置
	
	# 安装修复ivsoper密码过期的补丁
	echo "begin install vpu patch for pwd expired"
	cd SCRIPT
	sh InfoStreamDs_6.0_Patch_Fix_Pwd_Expired.sh
	cd -
	echo "end install vpu patch for pwd expired"
	
	# 修复core_pattern文件和定时清理core补丁
	echo "begin install vpu patch for core pattern"
	cd SCRIPT
	sh InfoStreamDs_6.0_Patch_Fix_CorePattern.sh
	cd -
	echo "end install vpu patch for core pattern"
	
	
	# 修复mu数据库连接数
	echo "begin install vpu patch for mu dbconnect cnt"
	cd SCRIPT
	sh InfoStreamDs_6.0_Change_Mu_Dbconnect_Cnt.sh
	cd -
	echo "end install vpu patch for mu dbconnect cnt"
	
	
	# 停止imgu
	echo "begin install vpu patch for stop imgu"
	cd SCRIPT
	sh InfoStreamDs_6.0_Patch_Stop_Imgu.sh
	cd -
	echo "end install vpu patch for stop imgu"
	
	# 修改nfs客户端参数
	echo "begin install vpu patch for modify nfs param"
	cd SCRIPT
	sh InfoStreamDs_6.0_Patch_Modify_Nfs_Param.sh
	cd -
	echo "end install vpu patch for modify nfs param"
	
	# 增加日志备份功能，修复日志下载功能，增加日志从备份路径下载
	echo "begin install log patch for modify nfs param"
	cd SCRIPT
    sh InfoStreamDs_6.0_Patch_Fix_Log_Collect.sh
    cd - 1>/dev/null
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install patch success"
	
	
	echo "end install vpu patch"
	
	Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install vpu patch success"
}

function list_installed_patch()
{
    if [ -f /home/ivstool/bin/log_bak.sh ] && false; then
        report_module_install_status "common_config" "$STATUS_INSTALLED"
		return "$STATUS_INSTALLED" 
    else
        report_module_install_status "common_config" "$STATUS_NOT_INSTALL"
		return "$STATUS_NOT_INSTALL" 
    fi
}

if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

install_patch

