# !/bin/sh

source ../../../common/InfoStreamDs_6.0_Patch_Common
patch_name=DCG_ONVIF_PLUGIN
dest_path_boost=/home/ivs_dcg/plugins/onvif_2.0.0/lib/third/lib/Boost
dest_path_adapter=/home/ivs_dcg/plugins/onvif_2.0.0/lib/adapter
dest_path_services=/home/ivs_dcg/plugins/onvif_2.0.0/lib/services
shell_name=$0
platform=""

function fix_onvif_offline()
{
	if [ "`arch`" != "x86_64" ];then
	    Log "$shell_name" "$FUNCNAME" "$LINENO" "platform not equal x86_64, platform error"
		report_error $patch_name
		exit 1
	fi
	platform=x86
	
	mkdir -p $dest_path_boost
	chown ivsdcg:dcg $dest_path_boost
    cp -f ./$platform/libboost_regex.so.1.72.0 $dest_path_boost/
	if [ $? -ne 0 ]; then
	    Log "$shell_name" "$FUNCNAME" "$LINENO" "copy libboost_regex.so.1.72.0 to $dest_path_boost failed"
	    report_error $patch_name
		return 1
	fi
	chmod 700 $dest_path_boost/libboost_regex.so.1.72.0
	chown ivsdcg:dcg $dest_path_boost/libboost_regex.so.1.72.0
	
	bash /home/ivstool/bin/service.sh stop dcg
	
	sleep 5s
	
	backup_file $dest_path_adapter/libdcg_adapter_onvif.so
	cp -f ./$platform/libdcg_adapter_onvif.so $dest_path_adapter
	if [ $? -ne 0 ]; then
	    Log "$shell_name" "$FUNCNAME" "$LINENO" "copy libdcg_adapter_onvif.so to $dest_path_adapter failed"
	    report_error $patch_name
		return 1
	fi
	
	backup_file $dest_path_services/libdcg_common.so
	cp -f ./$platform/libdcg_common.so $dest_path_services
	if [ $? -ne 0 ]; then
	    Log "$shell_name" "$FUNCNAME" "$LINENO" "copy libdcg_common.so to $dest_path_services failed"
	    report_error $patch_name
		return 1
	fi
	
	backup_file $dest_path_services/libdcg_service.so
	cp -f ./$platform/libdcg_service.so $dest_path_services
	if [ $? -ne 0 ]; then
	    Log "$shell_name" "$FUNCNAME" "$LINENO" "copy libdcg_service.so to $dest_path_services failed"
	    report_error $patch_name
		return 1
	fi
	
	bash /home/ivstool/bin/service.sh start dcg
	
	
	
	bash /home/ivstool/bin/service.sh restart scu
	
	Log "$shell_name" "$FUNCNAME" "$LINENO" "fix success"
	report_success $patch_name
}

function modify_config
{
    sed -i "s/ &amp;//g" /home/ivs_omu/config/ModuleManager.xml
	Log "$shell_name" "$FUNCNAME" "$LINENO" "modify ModuleManager.xml success"
}

modify_config
fix_onvif_offline
