# !/bin/sh

source ../../../common/InfoStreamDs_6.0_Patch_Common
patch_name=DCG_SDKSET_PLUGIN
dest_path_adapter=/home/ivs_dcg/plugins/sdkset_2.0.0/lib/adapter
dest_path_services=/home/ivs_dcg/plugins/sdkset_2.0.0/lib/services

shell_name=$0
platform=""

function fix_sdkset()
{
	if [ "`arch`" != "x86_64" ];then
	    Log "$shell_name" "$FUNCNAME" "$LINENO" "platform not equal x86_64, platform error"
		report_error $patch_name
		exit 1
	fi
	platform=x86
	
	bash /home/ivstool/bin/service.sh stop dcg
	
	sleep 5s
	
	backup_file $dest_path_adapter/libdcg_adapter_t28181.so
	cp -f ./$platform/libdcg_adapter_t28181.so $dest_path_adapter
	if [ $? -ne 0 ]; then
	    Log "$shell_name" "$FUNCNAME" "$LINENO" "copy libdcg_adapter_t28181.so to $dest_path_adapter failed"
	    report_error $patch_name
		return 1
	fi
	
	
	backup_file $dest_path_services/libdcg_common.so
	cp -f ./$platform/libdcg_common.so $dest_path_services
	if [ $? -ne 0 ]; then
	    Log "$shell_name" "$FUNCNAME" "$LINENO" "copy libdcg_common.so to $dest_path_services failed"
	    report_error $patch_name
		return 1
	fi
	
	backup_file $dest_path_services/libdcg_service.so
	cp -f ./$platform/libdcg_service.so $dest_path_services
	if [ $? -ne 0 ]; then
	    Log "$shell_name" "$FUNCNAME" "$LINENO" "copy libdcg_service.so to $dest_path_services failed"
	    report_error $patch_name
		return 1
	fi
	
	bash /home/ivstool/bin/service.sh start dcg

	Log "$shell_name" "$FUNCNAME" "$LINENO" "fix success"
	report_success $patch_name
}

fix_sdkset
