# !/bin/sh

source ../common/InfoStreamDs_6.0_Patch_Common
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"
patch_name=DCG
dest_dcg_path=/home/ivs_dcg/lib/services
src_dcg_path=./x86

function show_usage
{
    echo "usage: sh $0"
}

# 输入参数检查，参数个数0
function check_param
{
	return 0
}

function fix_dcg
{

	# 安装DCG补丁
	echo "begin install patch for dcg"
	sh /home/ivstool/bin/service.sh stop dcg	
	sleep 5s
	backup_file $dest_dcg_path/libdcg_service.so
	cp -f $src_dcg_path/libdcg_service.so $dest_dcg_path/libdcg_service.so	
	sh /home/ivstool/bin/service.sh start dcg
	echo "end install patch for dcg"

	# 安装插件补丁
	echo "begin install patch for onvif"
	cd PLUGIN/IVS_DCG_ONVIF/
	sh InfoStreamDs_6.0_Patch_Fix_Onvif_Offline.sh
	cd -
	echo "end install patch for onvif"
	
		# 安装插件补丁
	echo "begin install patch for sdkset"
	cd PLUGIN/IVS_DCG_SDKSET/
	sh InfoStreamDs_6.0_Patch_Fix_Sdkset.sh
	cd -
	echo "end install patch for sdkset"

	Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "fix success"
    report_success $patch_name
}

function list_installed_patch()
{
    local bin_file_name="libdcg_adapter_t28181.so"
    local bin_file_path="/home/ivs_dcg/plugins/sdkset_2.0.0/lib/adapter/libdcg_adapter_t28181.so"
    local module="dcg"
    local expect_md5="$(grep -a ${bin_file_name} ./md5sum.txt | awk -F ' ' '{print $1}')"
    local actual_md5="$(md5sum ${bin_file_path} | awk -F ' ' '{print $1}')"
    if [ "$actual_md5" != "$expect_md5" ]; then
        report_module_install_status "${module}" "$STATUS_NOT_INSTALL"
		return "$STATUS_NOT_INSTALL" 
    else
        report_module_install_status "${module}" "$STATUS_INSTALLED"
		return "$STATUS_INSTALLED" 
    fi
}


if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

fix_dcg



