#!/usr/bin/env sh

function append_to_config_file()
{
    local file="$1"
    local option="$2"
    local desc="$3"
    local tmp_file="${1}_tmp"
    local finish=0

    truncate -s 0 "$tmp_file"
    local old_ifs="$IFS"
    IFS=$'\n'    
    while read line; do 
        echo "$line" >> "$tmp_file"

        if [[ "$finish" != "1" ]] && [[ "$line" =~ ^\[MU_RECORD\] ]]; then

            echo -e "\n${desc}" >> "$tmp_file"
            echo "$option"      >> "$tmp_file"

            finish="1"
        fi
    done < "$file"

    IFS="$old_ifs"
    mv -f "$tmp_file" "$file"
    rm -f "$tmp_file"
}

function modify_config(){
    local config_file="$1"
    local key="$2"
    local value="$3"
    local desc="$4"
    local content
    
    content=$(grep -a "$key" "$config_file")
    if [ "$content" != "" ]; then
        sed -i "s/^\(${key}\s*=\s*\).*\$/\1${value}/"  "${config_file}"
    else
        append_to_config_file "$config_file" "${key}=${value}" "$desc" 
    fi  
}