#!/usr/bin/env sh

source ../common/InfoStreamDs_6.0_Patch_Common
source ./common.sh
patch_name=MU
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"


mu_dir="/home/ivs_mu"

platform=""
start_imgu="false"
start_mu="false"

function stop_process()
{
    result=$(ps -ef | grep ivs_imgu | grep -v grep | grep -v monitor)
    if [[ -n "$result" ]]; then
        start_imgu="true"
    fi
    result=$(ps -ef | grep ivs_mu | grep -v grep | grep -v monitor)
    if [[ -n "result" ]]; then
        start_mu="true"
    fi

    sh /home/ivstool/bin/service.sh stop mu
    sh /home/ivstool/bin/service.sh stop imgu   
}

function start_process()
{
    if [[ "$start_mu" == "true" ]]; then
        sh /home/ivstool/bin/service.sh start mu
    fi

    if [[ "$start_imgu" == "true" ]]; then
		# 默认停止imgu
        # sh /home/ivstool/bin/service.sh start imgu
		echo "no start imgu"
    fi
}

function backup()
{

	backup_file /home/ivs_mu/bin/ivs_mu
	backup_file /home/ivs_mu/lib/libbsm_kernel.so
	backup_file /home/ivs_mu/config/MU.conf
	backup_file /home/ivs_imgu/lib/libbsm_kernel.so
	
	Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "copy ivs_mu ivs_imgu success"
}

function add_upload_options_to_mu_config()
{
    local mu_config="config/MU.conf"
    cd "${mu_dir}"

	sed -i '/QueryRecordTimeRangeLength/d' "$mu_config"
	sed -i '/max time range from upload start time to past/d' "$mu_config"
	sed -i '/WaitTimerEventCountBetweenToSeg/d' "$mu_config"
	sed -i '/timer tick to wait util upload next seg/d' "$mu_config"
	sed -i '/MaxUploadSegLengthToIgnore/d'  "$mu_config"
	sed -i '/max length of seg to ignore after max retry upload in seconds/d' "$mu_config"
	
    modify_config "$mu_config" "EnableUpload"                     "0"     \
        "; 0 - disable uploading history record ; 1 - enable uploading history record"
    
    modify_config "$mu_config" "UploadSegRetryInterval"           "60"    \
        "; time to wait until next retry to upload seg in seconds"
    
    modify_config "$mu_config" "MaxUploadSegDurationToIgnore"       "10"    \
        "; max length of seg to ignore after max retry upload in seconds"
    
    modify_config "$mu_config" "TimerEventCountWaitBetweenSeg"   "3"     \
        "; timer tick to wait util upload next seg"
    
    modify_config "$mu_config" "QueryRecordTimeRangeLimit"       "3.0"   \
        "; max time range from upload start time to past, 1.0 means one day"

    modify_config "$mu_config" "MaxQueriedSegLimit"       "3000"   \
        "; max db records to retrive when search video records"
}

function update_mu()
{

    cp -f ./x86/ivs_mu /home/ivs_mu/bin/ivs_mu
    cp -f ./x86/libbsm_kernel.so /home/ivs_mu/lib/libbsm_kernel.so
	
    chown ivsmu:ivs /home/ivs_mu/bin/ivs_mu
    chmod 500 /home/ivs_mu/bin/ivs_mu

    chown ivsmu:ivs /home/ivs_mu/lib/libbsm_kernel.so 
    chmod 500 /home/ivs_mu/lib/libbsm_kernel.so  

    add_upload_options_to_mu_config
}


function update_imgu()
{
    cp -f ./x86/libbsm_kernel.so /home/ivs_imgu/lib/libbsm_kernel.so
    chown ivsmu:ivs /home/ivs_imgu/lib/libbsm_kernel.so 
    chmod 500 /home/ivs_imgu/lib/libbsm_kernel.so 
}

function install()
{
    backup && stop_process && update_imgu && update_mu && start_process || return 1
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install $patch_name succeed."
    return 0
}





function check_install_env()
{
    if [ "$(whoami)" != "root" ]; then
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "please run this script as root"
        return 1
    fi
    if [ "$(uname -m)" != "x86_64" ]; then 
        Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "wrong platform \'${platform}\', x86 or arm"
        return 1
    fi

    case "${platform}" in 
        "x86" )
            return 0
            ;;
        "arm" )
            return 0
            ;;
        *)
            Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "wrong platform \'${platform}\', x86 or arm"
            return 1
            ;;  
	esac
    return 0
}

function main()
{
    platform=x86
    check_install_env 
    if [ $? -ne 0 ]; then
        echo "${THIS_SCRIPT} stopped, please check out ${LOG_FILE_PATH} for detail information"
        exit 1
    fi
	
	install || exit 1
	
	report_success $patch_name
}

function list_installed_patch()
{
    local bin_file_name="ivs_mu"
    local bin_file_path="/home/ivs_mu/bin/ivs_mu"
    local module="mu"
    local expect_md5="$(grep -a ${bin_file_name} ./md5sum.txt | awk -F ' ' '{print $1}')"
    local actual_md5="$(md5sum ${bin_file_path} | awk -F ' ' '{print $1}')"
    if [ "$actual_md5" != "$expect_md5" ]; then
        report_module_install_status "${module}" "$STATUS_NOT_INSTALL"
		return "$STATUS_NOT_INSTALL"
    else
        report_module_install_status "${module}" "$STATUS_INSTALLED"
		return "$STATUS_INSTALLED" 
    fi
}


if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

main