#!/usr/bin/env sh
source ./common.sh

MU_CONF_FILE=/home/ivs_mu/config/MU.conf

function enable_upload
{
    cp ${MU_CONF_FILE} ${MU_CONF_FILE}.bak_$(date "+%Y%m%d%H%M%S")
    modify_config "$MU_CONF_FILE" "EnableUpload"   "1"  \
        "; 0 - disable uploading history record ; 1 - enable uploading history record"
}

function disable_upload
{
    cp ${MU_CONF_FILE} ${MU_CONF_FILE}.bak_$(date "+%Y%m%d%H%M%S")
    modify_config "$MU_CONF_FILE" "EnableUpload"   "0"     \
        "; 0 - disable uploading history record ; 1 - enable uploading history record"
}

function change_upload_range()
{
    cp ${MU_CONF_FILE} ${MU_CONF_FILE}.bak_$(date "+%Y%m%d%H%M%S")
	local new_range_value="$1"
    modify_config "$MU_CONF_FILE" "QueryRecordTimeRangeLimit"       "$new_range_value"   \
        "; max time range from upload start time to past, 1.0 means one day"	
}

function show_usage
{
    echo "usage: "
    echo "1. open/close uploading module"
    echo "   sh $0 [enable|disable]"
    echo "       enable - enable uploading history record"
    echo "       disable - disable uploading history record"
	echo "                         "
    echo "2. change uploading range"
    echo "   sh $0 chgrange <range>"
    echo "       <range> - number of days to restrict, for example,"
    echo "       1.0 represents 1 day, 1.5 reprents 1 half of day"
}

function change_upload_option()
{
    local option="$1"
	
	case "$option" in
		"enable")
			enable_upload
			return $?
		;;
		"disable")
			disable_upload
			return $?
		;;
		"chgrange")
			if [[ "$2" =~ ^[0-9]+(\.[0-9]+)? ]]; then
				change_upload_range "$2"
				return $?
			else
				echo "invalid range value"
				show_usage
				return 1
			fi
		;;
		*)
			show_usage
			return 1
		;;
	esac
}

function main()
{
    change_upload_option $@
    if [ $? -ne 0 ]; then 
        echo "change the uploading option failed"
        exit 1
    fi
    echo "change the uploading option succeed"
    exit 0
}

main $@


