#!/bin/bash
source ../common/InfoStreamDs_6.0_Patch_Common

THIS_PATCH_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null 2>&1 && pwd )"
BACKUP_DIR="/home/logs"
PCG_DIR="/home/ivs_pcg/mss-apache-tomcat/webapps/PCG"
PCG_BACKUP_ARCHIVE="pcg_backup_${VERSION}.tar.gz"
CRONTAB_BACKUP_FILE="crontab_backup_${VERSION}.txt"
PCG_CONFIG_FILE='WEB-INF/classes/pcg.properties'

function change_config(){
    local config_file="$1"
    local key="$2"
    local value="$3"
    sed -i "s/^\(${key}\s*=\s*\).*\$/\1${value}/"  "${config_file}"
}

function stop_process()
{
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "stopping the pcg process"        
    crontab -l > /home/logs/crontab_tmp
    crm resource stop IVS_PCG_TOMCAT
    crontab /home/logs/crontab_tmp
    sleep 5
}

function start_process()
{
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "starting the pcg process"        

    crontab -l > /home/logs/crontab_tmp
    crm resource restart IVS_PCG_TOMCAT 1>/dev/null 2>&1
    crontab /home/logs/crontab_tmp
    sleep 5
}

function restart_process()
{
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "starting the pcg process"        
    crontab -l > /home/logs/crontab_tmp
    crm resource restart IVS_PCG_TOMCAT 1>/dev/null 2>&1
    crontab /home/logs/crontab_tmp
    sleep 5
}

# 默认当前目录为 "../webapps/PCG"
# 如果pcg.properties文件中已有改配置项则修改为要设置的值; 否则
# 添加该配置项到文件中
function update_pcg_properties_file()
{
    local conf_key="$1"
    local conf_value="$2"
    local conf_desc="$3"
    local conf_file="WEB-INF/classes/pcg.properties"

    grep -aq "$conf_key" "$conf_file"
    if [ $? -eq 0 ]; then 
        change_config "$conf_file" "$conf_key" "$conf_value"
    else
        echo ""              >> "$conf_file"
        echo "# ${conf_desc}"  >> "$conf_file"
        echo "${conf_key}=${conf_value}" >> "$conf_file"
    fi    
}