#!/bin/sh
# vim: set tabstop=4 shiftwidth=4 fileformat=unix: 
#=======================================================================
#
#          FILE:  hacs_start_pcg.sh
# 
#         USAGE:  ./hacs_start_pcg.sh 
# 
#   DESCRIPTION:  HACS PCG START 
# 
#       OPTIONS:  ---
#  REQUIREMENTS:  ---
#          BUGS:  ---
#         NOTES:  ---
#        AUTHOR:  ---
#       COMPANY: Huawei Tech. Co., Ltd.
#       CREATED:  ---
#      REVISION:  ---
#=======================================================================
logfile="/home/ivs_pcg/hacs/monitor.log"
baklogfile="/home/ivs_pcg/hacs/monitor.log_bak"
ModuleName="ivs_pcg"

function writelog
{
    nowtime=`date '+%Y-%-m-%d %H:%M:%S'`
    if [ -f ${logfile} ]; then
        filesize=`stat -c "%s" ${logfile}`
        if [ 10485760 -le ${filesize} ];then
            mv -f ${logfile} ${baklogfile}
        fi 
    fi
    echo "[${nowtime}][monitor]$*" >> ${logfile}
}

function getivswebStatus
{
    writelog "enter getivswebStatus ..."
    typeset count=0
    count=`ps -ef | grep -v  "grep" | grep "${ModuleName}" | grep -c catalina`
    if [ ${count} -gt 0 ];then
        catalinaPID=`ps -ef | grep -v  "grep" | grep "${ModuleName}" | grep catalina | awk '{print $2}'`
        pcgPortInfo=`lsof -i:5061 | awk '{print $2}' | grep $catalinaPID`
        if [[ ! -z $pcgPortInfo ]];then
            writelog "pcgPortInfo is OK"
			writelog "start pcg success, pcg process [${catalinaPID}]."
            return 0
        fi
    fi

    writelog "The ivsweb server for $ModuleName is not running."
    return 1
}

startPCG()
{ 
    writelog "startPCG ...."
    # עPCG룬ںϵͳϣPCGRestfulʱ򣬶ʹrootȨ
    #su - root -c "cd /home/ivs_pcg/mss-apache-tomcat/bin && ./startup.sh" >/dev/null 2>&1
    su - root -c "cd /home/ivstool/bin && ./service.sh start pcg" >/dev/null 2>&1
    # Add by z00522056 ֹ˫pcg
    cd /etc/init.d && /sbin/chkconfig --del ivspcgd 2>/dev/null

    
    ### ˫лʱԭɾԶͬļ ###
    su - root -c "sed -i '/rsync_pcg/d' /var/spool/cron/tabs/root"
    [ -f /home/ivs_pcg/hacs/on_pcg_start.sh ] && sh /home/ivs_pcg/hacs/on_pcg_start.sh
    su - root -c "crontab /var/spool/cron/tabs/root"
    service cron restart
    
    SLEEP=300
    while [ $SLEEP -ge 0 ]; do
        ### ̼  ̴ڷ0 ڷ1 ###
        IsExistCnt=`ps -ef | grep -v "grep" | grep ivs_pcg | grep -c catalina`
        if [ $IsExistCnt -ne 0 ];then
            #checkTimeout=5
            #tmpfile="/home/ivs_pcg/hacs/web_result.tmp"
            #tmppagefile="/home/ivs_pcg/hacs/tmp_html.html"
            
            #iLine="http://127.0.0.1:port/PCG/PCG.do"
            #wget ${iLine} -T ${checkTimeout} -t 1 -o ${tmpfile} -O ${tmppagefile} >> /home/ivs_pcg/hacs/wget.log
            #tmp200=`cat $tmpfile | grep "200 OK" | grep -v "grep" | wc -l`
            #rm -rf $tmpfile
            #rm -rf ${tmppagefile}
            #writelog "while SLEEP:$SLEEP  tmp200:${tmp200}"
            
            # if [ ${tmp200} -ne 0 ]; then
                # writelog "The tmp200 is OK."
                # getivswebStatus
                # if [ $? -eq 0 ];then
                    # writelog "getivswebStatus is OK."
                    # break
                # fi
            # fi
            writelog "while SLEEP:$SLEEP  getivswebStatus"
            getivswebStatus
            if [ $? -eq 0 ];then
                writelog "getivswebStatus is OK."
                return 0
            fi
        fi
        sleep 1    
        SLEEP=`expr $SLEEP - 1 `
    done

} 

startPCG
