#!/bin/sh
# vim: set tabstop=4 shiftwidth=4 fileformat=unix: 
#=======================================================================
#
#          FILE:  hacs_stop_pcg
# 
#         USAGE:  ./hacs_stop_pcg 
# 
#   DESCRIPTION:  HACS PCG STOP 
# 
#       OPTIONS:  ---
#  REQUIREMENTS:  ---
#          BUGS:  ---
#         NOTES:  ---
#        AUTHOR:  ---
#       COMPANY: Huawei Tech. Co., Ltd.
#       CREATED:  ---
#      REVISION:  ---
#=======================================================================
function writelog
{
    nowtime=`date '+%Y-%-m-%d %H:%M:%S'`
    if [ -f /home/ivs_pcg/hacs/monitor.log ]; then
        filesize=`stat -c "%s" /home/ivs_pcg/hacs/monitor.log`
        if [ 10485760 -le ${filesize} ];then
            mv -f /home/ivs_pcg/hacs/monitor.log /home/ivs_pcg/hacs/monitor.log_bak
        fi 
    fi
    echo "[${nowtime}][monitor]$*" >> /home/ivs_pcg/hacs/monitor.log
}


stopPCG()
{ 
    pcgMonitorPID=`ps -ef | grep -v "grep" | grep ivsweb_monitor | awk '{print $2}'`
    if [ ${pcgMonitorPID} ]; then
        writelog "pcg ivsweb_monitor [${pcgMonitorPID}] is runing, stop it."
    fi
    ps -ef | grep -v "grep" | grep ivsweb_monitor | awk '{print $2}' | xargs kill -9
	
	pcgPID=`ps -ef | grep -v "grep" | grep ivs_pcg | grep catalina | awk '{print $2}'`
	if [ ${pcgPID} ]; then
        writelog "pcg [${pcgPID}] is running, stop it."
    fi
	ps -ef | grep -v "grep" | grep ivs_pcg | grep catalina | awk '{print $2}' | xargs kill -9
    
    ### ˫лʱԭ䱸ӱԶͬļ ###
    sed -i '/rsync_pcg/d' /var/spool/cron/tabs/root
    chmod u+x /home/ivs_pcg/rsync/rsync_pcg.sh 
    echo "* * * * * /home/ivs_pcg/rsync/rsync_pcg.sh >/dev/null 2>&1" >> /var/spool/cron/tabs/root
    [ -f /home/ivs_pcg/hacs/on_pcg_stop.sh ] && sh /home/ivs_pcg/hacs/on_pcg_stop.sh
    crontab /var/spool/cron/tabs/root
    service cron restart
    
    SLEEP=20
    while [ $SLEEP -ge 0 ]; do
        IsExistCnt=`ps -ef | grep -v "grep" | grep ivs_pcg | grep -c catalina`
        if [ $IsExistCnt -ne 0 ]; then
           writelog "stop ivs_pcg service failed. "
        else
            break
        fi  
        sleep 1    
        SLEEP=`expr $SLEEP - 1 `
    done
    
	pcgPID=`ps -ef | grep -v "grep" | grep ivs_pcg | grep catalina | awk '{print $2}'`
	if [ ${pcgPID} ]; then
        writelog "pcg [${pcgPID}] is still running, stop it again."
    fi
    ps -ef | grep -v "grep" | grep ivs_pcg | grep catalina | awk '{print $2}' | xargs kill -9
    rm -rf /home/ivs_pcg/mss-apache-tomcat/bin/.catalina.pid

    return 0
} 

stopPCG
