#!/usr/bin/env sh

source ./common.sh

PCG_DIR="/home/ivs_pcg/mss-apache-tomcat/webapps/PCG"
config_file=WEB-INF/classes/pcg.properties


function show_usage()
{
	echo "$0 enable-rtsp-auto-clean [true | false]"
}


case "$1" in 
	"enable-rtsp-auto-clean")
			if [[ "$2" == "true" ]]; then
				cd "$pcg_dir" && change_config "$config_file" "pcg.rtspSession.enableAutoClean" "true" && restart_process 
				exit $?
			elif [[ "$2" == "false" ]]; then
				cd "$pcg_dir" && change_config "$config_file" "pcg.rtspSession.enableAutoClean" "false" && restart_process
				exit $?
			else
				echo "invalid argument"
				show_usage
				exit 1
			fi
	;;
	*)
		show_usage
		exit 1
	;;
esac 