#!/bin/sh
source ./common.sh

function show_usage
{
    echo "usage: sh $0 [mmu_master | mmu_slave]"
}

# 输入参数检查
function check_param
{
    if [ $# -lt 1 ];then
        return 1
    fi
    return 0
}

function recover()
{
    local mmu_type="$1"

    if [[ "$mmu_type" == "mmu_master" ]]; then
        stop_process 
    fi

    rm -f  /home/ivs_pcg/hacs/on_pcg_start.sh   || true
    rm -f  /home/ivs_pcg/hacs/on_pcg_stop.sh    || true
    rm -f /home/ivstool/bin/InfoStreamDs_6.0_Crontab_Restart_PCG.sh || true
    tar --overwrite  -C / -xzf "${BACKUP_DIR}/${PCG_BACKUP_ARCHIVE}" --wildcards "home/ivs_pcg/hacs/*.sh"
    chmod 700 /home/ivs_pcg/hacs/*.sh
    chown ivspcg:ivs /home/ivs_pcg/hacs/*.sh
    cd "${PCG_DIR}"
    tar --overwrite -xzf "${BACKUP_DIR}/${PCG_BACKUP_ARCHIVE}"  "*.class" "$PCG_CONFIG_FILE"  

    for f in  $(find . -name '*.class'); do 
        chmod 700 "$f" && chown ivspcg:ivs "$f"
    done


    for f in "$PCG_CONFIG_FILE"; do 
        chmod 600 "$f" && chown ivspcg:ivs "$f"
    done

    if [[ "$mmu_type" == "mmu_master" ]]; then
        if crontab -l | grep -q 'InfoStreamDs_6.0_Crontab_Restart_PCG' ; then
            crontab -l > ./crontab_tmp
            sed -i '/InfoStreamDs_6.0_Crontab_Restart_PCG/d' ./crontab_tmp
            crontab ./crontab_tmp
        fi
        start_process 
    fi
}

function recover_patch
{
    local node="$1"
    local ret=0

    check_param "$@"
    if [ $? -ne 0 ]; then
        show_usage
        return 1
    fi

    if [ "$node" != "mmu_master" ] && [ "$node" != "mmu_slave" ]; then
        echo "invalid node type ${node}"
        return 1
    fi
    recover "$node"
    ret=$?
    return $ret
}

recover_patch "$@"