# !/bin/sh

common_path=/opt/InfoStream_app/InfoStreamDS_iDeploy/common

source ${common_path}/comm_func.sh
source ../common/InfoStreamDs_6.0_Patch_Common
patch_name=RESTFUL
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"

SRC_FILE_PATH=./restful/hacs
DST_FILE_PATH=/home/ivs_restful/hacs


function prepare_restful_hacs()
{
	mkdir -p $DST_FILE_PATH
	cp $SRC_FILE_PATH/* $DST_FILE_PATH/
	chmod 550 $DST_FILE_PATH/*.sh
	chmod 600 $DST_FILE_PATH/*.xml
	
	OuterServiceFloatIP=`getVarible HACSFloatIP`
	Log "$FUNCNAME" "$LINENO" "get FloatIP:$OuterServiceFloatIP"
	sed -i "s/^server.listen.ip=.*/server.listen.ip=${OuterServiceFloatIP}/g" /home/ivs_restful/config/keystore.properties
	sed -i "s+restful.innerservice.ip=\(.*\)+restful.innerservice.ip=${OuterServiceFloatIP}+g" /home/ivs_restful/config/nss.properties
}

function install_restful_hacs()
{
	isPrimary=$1
	
    # 检查result是否已经加入双机管理
	ivs_restful_hacs_exist=`crm status | grep IVS_RESTFUL | grep Started`
	if [ ! ivs_restful_hacs_exist ]; then
		Log "ivs_restful is already in hacs resource"
		return 0;
	fi
	
	# 先停result
	/home/ivstool/bin/service.sh stop restful
	
	prepare_restful_hacs
	# 如果是域主备节点，则只执行拷贝和修改配置动作
	if [ $isPrimary -eq 0 ]; then
		Log "$FUNCNAME" "$LINENO" "slave node, finish"
		return 0
	fi

    # 双机rsync同步任务
    Log "$FUNCNAME" "$LINENO" "[/var/spool/cron/tabs/root] for hacs "
    if [ -f /var/spool/cron/tabs/root ];then
         /bin/sed -i "/rsync_restful/d" /var/spool/cron/tabs/root
    fi
    echo "* * * * * /home/ivstool/bin/rsync_restful.sh >/dev/null 2>&1" >> /var/spool/cron/tabs/root

    # 双机rsync配置文件
    Log "$FUNCNAME" "$LINENO" "[/etc/rsyncd.conf] for hacs "
    if [ -f /etc/rsyncd.conf ];then
        cat /etc/rsyncd.conf | grep ivs_restful
        if [ $? -ne 0 ];then
            hostIp=`cat /etc/rsyncd.conf | grep 'hosts allow =' | uniq | awk '{print $4}'`

            echo "" >> /etc/rsyncd.conf
            echo "" >> /etc/rsyncd.conf
            echo "[IVSRESTFUL]
path = /home/ivs_restful/config
comment = config file
ignore errors
read only = true
list = false
uid = root
gid = root
hosts allow = ${hostIp}" >> /etc/rsyncd.conf
        else
            Log "$FUNCNAME" "$LINENO" "ivs_restful config has already in file[/etc/rsyncd.conf]"
        fi
    else
        Log "$FUNCNAME" "$LINENO" "file [/etc/rsyncd.conf] is not exist!"
    fi
    
    # 双机主机:: 新增双机纳管
    cat /var/lib/heartbeat/crm/cib.xml | grep ivs_restful
    if [ $? -eq 0 ];then
        Log "$FUNCNAME" "$LINENO" "IVS_RESTFUL is already managered by hacs" 
        #return 0
    fi

    Log "$FUNCNAME" "$LINENO" "config restful for hacs manager" 
    hostName=`hostname`
    resCheck=`crm resource status FloatIP 2>/dev/null`
    echo ${resCheck} | grep ${hostName} > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        crm configure primitive IVS_RESTFUL ocf:users:ComplexApp \
        params start_sh="/home/ivs_restful/hacs/hacs_start_restful.sh" stop_sh="/home/ivs_restful/hacs/hacs_stop_restful.sh" status_sh="/home/ivs_restful/hacs/hacs_monitor_restful.sh" app_user="root" \
        op monitor interval="60s" timeout="60s" start-delay="300s" \
        op start interval="0s" timeout="360s" \
        op stop interval="0s" timeout="360s" \
        meta resource-stickiness="3000" migration-threshold="3" target-role="Started" >/dev/null 2>&1
        if [ $? -ne 0 ]; then
            Log "$FUNCNAME" "$LINENO" "Dual server. Add IVS_RESTFUL resource for HACS failed. exit!"
            exit 1
        fi
        sleep 5

        crm configure order restfulOrder1 inf: FloatIP:start IVS_RESTFUL:start   
        if [ $? -ne 0 ]; then
            Log "$FUNCNAME" "$LINENO" "Dual server. Add IVS_RESTFUL order for HACS failed. exit!"
            exit 1
        fi
        sleep 5
         
        crm configure colocation restfulColocation1 inf: IVS_RESTFUL FloatIP
        if [ $? -ne 0 ]; then
            Log "$FUNCNAME" "$LINENO" "Dual server. Add NGINX colocation for HACS failed. exit!"
            exit 1
        fi
        sleep 5

        crm resource meta IVS_RESTFUL  set failure-timeout 630

        crm resource start IVS_RESTFUL
        Log "$FUNCNAME" "$LINENO" "crm start restful, result=$? "
    fi

    return 0
}


function show_usage()
{
    echo "usage: sh ${THIS_SCRIPT} [mmu_master|mmu_slave]"
}

# 输入参数检查，参数个数0
function check_param()
{
    if [ $# -ne 1 ];then
	    show_usage
		return 1
	fi
}

function list_installed_patch()
{
    local bin_file_name="initForHacs.sh"
    local bin_file_path="/home/ivs_restful/hacs/initForHacs.sh"
    local module="restful"
    local expect_md5="$(grep -a ${bin_file_name} ./md5sum.txt | awk -F ' ' '{print $1}')"
    local actual_md5="$(md5sum ${bin_file_path} | awk -F ' ' '{print $1}')"
    if [ "$actual_md5" != "$expect_md5" ]; then
        report_module_install_status "${module}" "$STATUS_NOT_INSTALL"
		return $STATUS_NOT_INSTALL
    else
        report_module_install_status "${module}" "$STATUS_INSTALLED"
		return "$STATUS_INSTALLED" 
    fi
}

function install_patch()
{
	check_param "$@"
    if [ $? -ne 0 ]; then
        show_usage
        return 1
    fi

    local ret=0
    local node="$1"

    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "begin install restful patch, node: ${node}"

    # MMU主节点安装补丁
    if [ "$node" == "mmu_master" ]; then
        # 安装restful补丁
		echo "begin install mmu master patch for restful"
		install_restful_hacs 1
		Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install mmu master patch success"
    # MMU备节点安装补丁
    elif [ "$node" == "mmu_slave" ]; then
        # 安装restful补丁
		echo "begin install mmu slave patch for restful"
		install_restful_hacs 0
		Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install mmu slave patch success"
    else
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "invalid node type ${node}"
        ret=1
    fi
	
	Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install restful patch Successful"
	echo "InfoStreamDs_6.0_Full_Patch_Package_restful install end"
    return $ret
}

if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

install_patch $@