#!/bin/bash
# vim: set tabstop=4 shiftwidth=4 fileformat=unix:
#=======================================================================
#
#          FILE:  initForHacs.sh
#
#         USAGE:  ./initForHacs.sh
#
#   DESCRIPTION:  RESTFUL双机模式
#
#       OPTIONS:  ---
#  REQUIREMENTS:  ---
#          BUGS:  ---
#         NOTES:  ---
#        AUTHOR:
#       COMPANY: Huawei Tech. Co., Ltd.
#       CREATED:
#      REVISION:  ---
#=======================================================================
program=$(dirname $(readlink -f "$0"))
source $program/../../common/ivs_common.sh
source $program/../../common/ivs_common_hacs.sh
source $program/../../common/ivs_errdef.sh
source $program/../conf/deploy.conf
source $program/../conf/userinfo.conf

# cloudconfig配置项
FILE_CLOUD_CONFIG=/home/ivs_common/cloudconfig.xml
RESTFUL_LOCATION=/home/ivs_restful
FILE_RESTFUL_PROPERTIES=${RESTFUL_LOCATION}/config/nss.properties


function initConfig()
{
    [[ "${ProductType}" != "${CloudIVS3000}" && "${ProductType}" != "${CloudIVS9000}" && "${ProductType}" != "${Box}" ]] && logEchoInstallation "[ERROR] ProductType=${ProductType} is unknown"

    #一、端口的IP配置
    if [ "${ProductType}" == "${Box}" ]; then
        logEchoInstallation "[INFO] For Box environment,no need to modify"
    elif [ "${ProductType}" == "${CloudIVS9000}" -o "${ProductType}" == "${CloudIVS3000}" ]; then
        #双机情况下restful自己插入eth3:0网卡，单机由bma插入eth3网卡
        sed -i "s/^server.listen.ip=.*/server.listen.ip=${OuterServiceFloatIP}/g"  ${HOME}/config/keystore.properties >/dev/null 2>&1
        logEchoInstallation "[INFO] sed -i \"s/^server.listen.ip=.*/server.listen.ip=${OuterServiceFloatIP}/g\"  ${HOME}/config/keystore.properties result=$?"
    fi
    # 二.双机下修改restful链接smu的内部ip,单机下直接读eth2
    local eth_label="vNIC2"
    local containner_label="VCNAPI"
    local INNER_IP=`xmllint --xpath "/CloudConfig/IPPool/${containner_label}_${eth_label}_FloatIP/text()" ${FILE_CLOUD_CONFIG}`
    local oldVal=`grep restful.innerservice.ip ${FILE_RESTFUL_PROPERTIES} | cut -d '=' -f2`
    if [ "-${oldVal}" == "-" -o "-${oldVal}" != "-${INNER_IP}" ];then
        sed -i "s+restful.innerservice.ip=\(.*\)+restful.innerservice.ip=${INNER_IP}+g" ${FILE_RESTFUL_PROPERTIES}
        logEchoInstallation "[INFO] Set [restful.innerservice.ip] value to [${INNER_IP}]."
    fi

}


function main()
{   
    # 调用ivs_common.sh、ivs_common_hacs.sh中的公共函数获取全局变量
    ProductType=`getProductType`
    getConfig
    getHacsConfig
    getContainerType

    # 一、具体的业务操作
    logEchoInstallation "[INFO] start restful initConfig() ..."
    initConfig
    [ $? -ne 0 ] && logEchoInstallation "[ERROR] initConfig() failed!"
    
    
    # 二、双机固定模板：配置双机，管理该资源
    if [ "${ProductType}" == "${Box}" ]; then
        specificXML=$program/../hacs/hacs_manage_for_Box.xml
    elif [ "${ProductType}" == "${CloudIVS9000}" ]; then
        specificXML=$program/../hacs/hacs_manage_for_CloudVCN.xml
    elif [ "${ProductType}" == "${CloudIVS3000}" ]; then
        specificXML=$program/../hacs/hacs_manage_for_CloudIVS3000.xml
    fi
    [ -f ${specificXML} ] && cp -f ${specificXML} $program/../hacs/hacs_manage.xml && logEchoInstallation "[INFO] cp -f ${specificXML} $program/../hacs/hacs_manage.xml result=$?"
    
    logEchoInstallation "[INFO] start setHacs($program/..) ..."
    setHacs "$program/.."
    resSetHacs=$?
    return ${resSetHacs}
}

# main
main
res=$?
exit ${res}
