#!/bin/sh

source ../common/InfoStreamDs_6.0_Patch_Common
patch_name=InfoStreamDs_6.0_Patch_Fix_Scu
dest_path_scu=/home/ivs_scu/lib/services
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"


function copy_so_file_scu
{
    if [ "`arch`" = "x86_64" ];then
		scu_file_manager_service=./x86/libmanager_service.so
    else
        return 1
    fi
    
	backup_file $dest_path_scu/libmanager_service.so
	cp -f $scu_file_manager_service $dest_path_scu
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "copy files success"
}

function fix_scu
{
    sh /home/ivstool/bin/service.sh stop scu
    
    sleep 5s
    
    copy_so_file_scu
    
    sh /home/ivstool/bin/service.sh start scu
    
    #check_install_result
    if [ $? -ne 0 ]; then
        return 1
        report_error $patch_name
    fi
    
    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "fix success"
    report_success $patch_name
}

function show_usage
{
    echo "usage: sh $0"
    echo "         sh status"
}

# 输入参数检查，参数个数0
function check_param
{
    return 0
}

function list_installed_patch()
{
    local bin_file_name="libmanager_service.so"
    local bin_file_path="${dest_path_scu}/libmanager_service.so"
    local module="scu"
    local expect_md5="$(grep -a ${bin_file_name} ./md5sum.txt | awk -F ' ' '{print $1}')"
    local actual_md5="$(md5sum ${bin_file_path} | awk -F ' ' '{print $1}')"
    if [ "$actual_md5" != "$expect_md5" ]; then
        report_module_install_status "${module}" "$STATUS_NOT_INSTALL"
        return $STATUS_NOT_INSTALL
    else
        report_module_install_status "${module}" "$STATUS_INSTALLED"
        return $STATUS_INSTALLED
    fi
}


if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

fix_scu
