# !/bin/sh

source ../common/InfoStreamDs_6.0_Patch_Common
patch_name=SMU
THIS_SCRIPT="$(basename $(pwd))/$(basename $0)"

dest_path=/home/ivs_smu/lib/services
src_path=./x86


function show_usage()
{
    echo "usage: sh $(THIS_SCRIPT) [mmu_master|mmu_slave]"
}

# 输入参数检查，参数个数0
function check_param()
{
    if [ $# -ne 1 ];then
	    show_usage
		return 1
	fi
}

function install_patch()
{
	check_param "$@"
    if [ $? -ne 0 ]; then
        show_usage
        return 1
    fi

    local ret=0
    local node="$1"

    Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "begin install smu patch, node: ${node}"

    # MMU主节点安装补丁
    if [ "$node" == "mmu_master" ]; then
        # 安装SMU补丁
		echo "begin install mmu master patch for smu"
		
		# 安装CU客户端导入设备模板超时问题补丁
		sh /home/ivstool/bin/service.sh stop smu
		sleep 5
		backup_file $dest_path/libsmu_service_device.so
		cp -f $src_path/libsmu_service_device.so $dest_path/libsmu_service_device.so
		sh /home/ivstool/bin/service.sh start smu
		
		
		Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install mmu master patch success"
    # MMU备节点安装补丁
    elif [ "$node" == "mmu_slave" ]; then
        # 安装SMU补丁
		echo "begin install mmu slave patch for smu"
		
		# 安装CU客户端导入设备模板超时问题补丁
		
		backup_file $dest_path/libsmu_service_device.so
		cp -f $src_path/libsmu_service_device.so $dest_path/libsmu_service_device.so

		Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install mmu slave patch success"
    else
        log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "invalid node type ${node}"
        ret=1
    fi
	
	Log "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "install smu patch Successful"
	echo "InfoStreamDs_6.0_Full_Patch_Package_Smu install end"
    return $ret
}


function list_installed_patch()
{
    local bin_file_name="libsmu_service_device.so"
    local bin_file_path="/home/ivs_smu/lib/services/libsmu_service_device.so"
    local module="smu"
    local expect_md5="$(grep -a ${bin_file_name} ./md5sum.txt | awk -F ' ' '{print $1}')"
    local actual_md5="$(md5sum ${bin_file_path} | awk -F ' ' '{print $1}')"
    if [ "$actual_md5" != "$expect_md5" ]; then
        report_module_install_status "${module}" "$STATUS_NOT_INSTALL"
		return "$STATUS_NOT_INSTALL" 
    else
        report_module_install_status "${module}" "$STATUS_INSTALLED"
		return "$STATUS_INSTALLED" 
    fi
}


if [ "$2" == "$OP_LIST_INSTALLED" ]; then
    list_installed_patch "$@"
    exit 0
fi

list_installed_patch
if [ $? -eq "$STATUS_INSTALLED" ]; then
    log_and_print_console "$THIS_SCRIPT" "$FUNCNAME" "$LINENO" "patch already installed, skip it"
    exit 0 
fi

install_patch $@



