#!/bin/bash
source ../common/InfoStreamDs_6.0_Patch_Common

function show_usage
{
    echo "usage: sh $0 [mmu_master | mmu_slave]"
}

# 输入参数检查
function check_param
{
    if [ $# -lt 1 ];then
        return 1
    fi
    return 0
}

function recover()
{
    local mmu_type="$1"

    if [[ "$mmu_type" == "mmu_master" ]]; then
        sh /home/ivstool/bin/service.sh stop smu
        sleep 5
    fi
	
	rollback_file /home/ivs_smu/lib/services/libsmu_service_device.so
	
    if [[ "$mmu_type" == "mmu_master" ]]; then
        sh /home/ivstool/bin/service.sh start smu 
    fi
}

function recover_patch
{
    local node="$1"
    local ret=0

    check_param "$@"
    if [ $? -ne 0 ]; then
        show_usage
        return 1
    fi

    if [ "$node" != "mmu_master" ] && [ "$node" != "mmu_slave" ]; then
        echo "invalid node type ${node}"
        return 1
    fi
    recover "$node"
    ret=$?
    return $ret
}

recover_patch "$@"