#!/bin/sh

function checkMuMem()
{
    mu_pid=$(pidof ivs_mu)
    if [ -z "${mu_pid}" ]; then
        return
    fi
    
    local_ip=$(ifconfig | grep -w inet | head -n1 | awk '{print $2}')

    mu_mem=$(ps -aux | grep -w ${mu_pid} | grep -v grep | awk '{print $6}')
    if [ -n "${mu_mem}" ] && [ ${mu_mem} -gt 8000000 ];then
        echo "$(date +'%F %T') [${local_ip}], ivs_mu[${mu_pid}] memuse[${mu_mem}K], now restart." >> /mnt/9000_0/check_mu_mem.log
        kill -11 ${mu_pid}
    fi
}


shell_name="check_mu_mem.sh"
shell_path=$(cd $(dirname $0);pwd)
crontab -l | grep -q ${shell_name}
if [ $? -ne 0 ];then
	crontab -l > ./crontab.log
	echo "*/3 * * * * nohup sh ${shell_path}/${shell_name} &>/dev/null &" >> ./crontab.log
	crontab < ./crontab.log
	rm -f ./crontab.log
fi

checkMuMem
