/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;

class NativeCursors {
    NativeCursors() {
    }

    static void colorKeyCursor(byte[] byArray, Buffer buffer, int n, int n2) {
        switch (n) {
            case 32: {
                NativeCursors.colorKeyCursor32(byArray, (IntBuffer)buffer, n2);
                break;
            }
            case 16: {
                NativeCursors.colorKeyCursor16(byArray, (ShortBuffer)buffer, n2);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    static void offsetCursor(Buffer buffer, Buffer buffer2, int n, int n2, int n3, int n4, int n5, int n6) {
        switch (n5) {
            case 32: {
                NativeCursors.offsetCursor32((IntBuffer)buffer, (IntBuffer)buffer2, n, n2, n3, n4, n6);
                break;
            }
            case 16: {
                NativeCursors.offsetCursor16((ShortBuffer)buffer, (ShortBuffer)buffer2, n, n2, n3, n4, n6);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static void colorKeyCursor32(byte[] byArray, IntBuffer intBuffer, int n) {
        IntBuffer intBuffer2 = ByteBuffer.wrap(byArray).asIntBuffer();
        while (intBuffer2.position() < intBuffer2.limit()) {
            int n2 = intBuffer2.get();
            if ((n2 & 0xFF) == 0) {
                intBuffer.put(n);
                continue;
            }
            intBuffer.put(n2);
        }
        intBuffer.rewind();
    }

    private static void colorKeyCursor16(byte[] byArray, ShortBuffer shortBuffer, int n) {
        IntBuffer intBuffer = ByteBuffer.wrap(byArray).asIntBuffer();
        while (intBuffer.position() < intBuffer.limit()) {
            int n2 = intBuffer.get();
            if ((n2 & 0xFF) == 0) {
                shortBuffer.put((short)n);
                continue;
            }
            int n3 = n2 >> 8 & 0xF800 | n2 >> 5 & 0x7E0 | n2 >> 3 & 0x1F;
            shortBuffer.put((short)n3);
        }
        shortBuffer.rewind();
    }

    private static void offsetCursor32(IntBuffer intBuffer, IntBuffer intBuffer2, int n, int n2, int n3, int n4, int n5) {
        if (n == 0 && n2 == 0) {
            intBuffer2.put(intBuffer);
        } else {
            int n6;
            int n7;
            for (n7 = 0; n7 < n2; ++n7) {
                for (n6 = 0; n6 < n3; ++n6) {
                    intBuffer2.put(n5);
                }
            }
            while (n7 < n4) {
                for (n6 = 0; n6 < n; ++n6) {
                    intBuffer2.put(n5);
                }
                int n8 = (n7 - n2) * n3;
                intBuffer.limit(n8 + n3 - n6);
                intBuffer.position(n8);
                intBuffer2.put(intBuffer);
                ++n7;
            }
        }
        intBuffer.rewind();
        intBuffer.limit(intBuffer.capacity());
        intBuffer2.rewind();
        intBuffer2.limit(intBuffer2.capacity());
    }

    private static void offsetCursor16(ShortBuffer shortBuffer, ShortBuffer shortBuffer2, int n, int n2, int n3, int n4, int n5) {
        if (n == 0 && n2 == 0) {
            shortBuffer2.put(shortBuffer);
        } else {
            int n6;
            int n7;
            for (n7 = 0; n7 < n2; ++n7) {
                for (n6 = 0; n6 < n3; ++n6) {
                    shortBuffer2.put((short)n5);
                }
            }
            while (n7 < n4) {
                for (n6 = 0; n6 < n; ++n6) {
                    shortBuffer2.put((short)n5);
                }
                int n8 = (n7 - n2) * n3;
                shortBuffer.limit(n8 + n3 - n6);
                shortBuffer.position(n8);
                shortBuffer2.put(shortBuffer);
                ++n7;
            }
        }
        shortBuffer.rewind();
        shortBuffer.limit(shortBuffer.capacity());
        shortBuffer2.rewind();
        shortBuffer2.limit(shortBuffer2.capacity());
    }
}

