/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxArch;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;

class SysFS {
    static final String CURSOR_BLINK = "/sys/devices/virtual/graphics/fbcon/cursor_blink";

    SysFS() {
    }

    static Map<String, BitSet> readCapabilities(File file) {
        HashMap<String, BitSet> hashMap = new HashMap<String, BitSet>();
        File[] fileArray = new File(file, "device/capabilities").listFiles();
        if (fileArray == null) {
            return hashMap;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            try {
                String[] stringArray;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(fileArray[i]));
                String string = bufferedReader.readLine();
                bufferedReader.close();
                if (string == null || (stringArray = string.split(" ")) == null) continue;
                byte[] byArray = new byte[stringArray.length * (LinuxArch.is64Bit() ? 8 : 4)];
                ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                for (int j = stringArray.length - 1; j >= 0; --j) {
                    if (LinuxArch.is64Bit()) {
                        byteBuffer.putLong(Long.parseUnsignedLong(stringArray[j], 16));
                        continue;
                    }
                    byteBuffer.putInt(Integer.parseUnsignedInt(stringArray[j], 16));
                }
                hashMap.put(fileArray[i].getName(), BitSet.valueOf(byArray));
                continue;
            }
            catch (IOException | RuntimeException exception) {
                exception.printStackTrace();
            }
        }
        return hashMap;
    }

    static Map<String, String> readUEvent(File file) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file2 = new File(file, "device/uevent");
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf("=");
                if (n < 0) continue;
                hashMap.put(string.substring(0, n), string.substring(n + 1));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return hashMap;
    }

    static void triggerUdevNotification(String string) {
        File[] fileArray = new File("/sys/class/" + string).listFiles();
        byte[] byArray = "change".getBytes();
        for (File file : fileArray) {
            File file2 = new File(file, "uevent");
            if (!file2.exists()) continue;
            try {
                SysFS.write(file2.getAbsolutePath(), byArray);
            }
            catch (IOException iOException) {
                System.err.println("Udev: Failed to write to " + file2);
                System.err.println("      Check that you have permission to access input devices");
                if (iOException.getMessage().contains("Permission denied")) continue;
                iOException.printStackTrace();
            }
        }
    }

    static void write(String string, byte[] byArray) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(string);){
            fileOutputStream.write(byArray);
        }
    }

    static void write(String string, String string2) throws IOException {
        SysFS.write(string, string2.getBytes());
    }

    static int[] readInts(String string, int n) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        if (string2 != null && string2.length() > 0) {
            String[] stringArray = string2.split(",");
            try {
                if (n == 0 || stringArray.length == n) {
                    int[] nArray = new int[stringArray.length];
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = Integer.parseInt(stringArray[i]);
                    }
                    return nArray;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (n != 0) {
            throw new IOException("Expected to find " + n + " integers in " + string + " but found '" + string2 + "'");
        }
        return new int[0];
    }

    static int readInt(String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        bufferedReader.close();
        try {
            if (string2 != null && string2.length() > 0) {
                return Integer.parseInt(string2);
            }
            throw new IOException(string + " does not contain an integer");
        }
        catch (NumberFormatException numberFormatException) {
            throw new IOException(string + " does not contain an integer ('" + string2 + "'");
        }
    }
}

